@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCrossRegionBackups.
 * @property backupId
 * @property backups
 * @property crossBackupId
 * @property crossBackupRegion
 * @property dbInstanceId
 * @property endTime
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property resourceGroupId
 * @property startTime
 */
public data class GetCrossRegionBackupsResult(
    public val backupId: String? = null,
    public val backups: List<GetCrossRegionBackupsBackup>,
    public val crossBackupId: String? = null,
    public val crossBackupRegion: String? = null,
    public val dbInstanceId: String,
    public val endTime: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetCrossRegionBackupsResult): GetCrossRegionBackupsResult = GetCrossRegionBackupsResult(
            backupId = javaType.backupId().map({ args0 -> args0 }).orElse(null),
            backups = javaType.backups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionBackupsBackup.Companion.toKotlin(args0)
                })
            }),
            crossBackupId = javaType.crossBackupId().map({ args0 -> args0 }).orElse(null),
            crossBackupRegion = javaType.crossBackupRegion().map({ args0 -> args0 }).orElse(null),
            dbInstanceId = javaType.dbInstanceId(),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
