@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCrossRegions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of region IDs.
 * @property outputFile
 * @property regions The list of destination regions that support cross-region backup. Each element contains the following attributes:
 */
public data class GetCrossRegionsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val regions: List<GetCrossRegionsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetCrossRegionsResult): GetCrossRegionsResult = GetCrossRegionsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetCrossRegionsRegion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
