@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property classCode The code of the instance type.
 * @property classGroup The instance family of the instance.
 * @property cpu The number of cores that are supported by the instance type. Unit: cores.
 * @property instructionSetArch The architecture of the instance type.
 * @property maxConnections The maximum number of connections that are supported by the instance type. Unit: connections.
 * @property maxIombps The maximum I/O bandwidth that is supported by the instance type. Unit: Mbit/s.
 * @property maxIops The maximum input/output operations per second (IOPS) that is supported by the instance type. Unit: operations per second.
 * @property memoryClass The memory capacity that is supported by the instance type. Unit: GB.
 * @property referencePrice The fee that you must pay for the instance type. Unit: cent (USD).
 */
public data class GetInstanceClassInfosInfo(
    public val classCode: String? = null,
    public val classGroup: String? = null,
    public val cpu: String? = null,
    public val instructionSetArch: String? = null,
    public val maxConnections: String? = null,
    public val maxIombps: String? = null,
    public val maxIops: String? = null,
    public val memoryClass: String? = null,
    public val referencePrice: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceClassInfosInfo): GetInstanceClassInfosInfo = GetInstanceClassInfosInfo(
            classCode = javaType.classCode().map({ args0 -> args0 }).orElse(null),
            classGroup = javaType.classGroup().map({ args0 -> args0 }).orElse(null),
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            instructionSetArch = javaType.instructionSetArch().map({ args0 -> args0 }).orElse(null),
            maxConnections = javaType.maxConnections().map({ args0 -> args0 }).orElse(null),
            maxIombps = javaType.maxIombps().map({ args0 -> args0 }).orElse(null),
            maxIops = javaType.maxIops().map({ args0 -> args0 }).orElse(null),
            memoryClass = javaType.memoryClass().map({ args0 -> args0 }).orElse(null),
            referencePrice = javaType.referencePrice().map({ args0 -> args0 }).orElse(null),
        )
    }
}
