@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceClassInfos.
 * @property commodityCode
 * @property dbInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Rds instance class codes.
 * @property infos A list of Rds available resource. Each element contains the following attributes:
 * @property orderType
 * @property outputFile
 */
public data class GetInstanceClassInfosResult(
    public val commodityCode: String,
    public val dbInstanceId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val infos: List<GetInstanceClassInfosInfo>? = null,
    public val orderType: String,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceClassInfosResult): GetInstanceClassInfosResult = GetInstanceClassInfosResult(
            commodityCode = javaType.commodityCode(),
            dbInstanceId = javaType.dbInstanceId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            infos = javaType.infos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassInfosInfo.Companion.toKotlin(args0)
                })
            }),
            orderType = javaType.orderType(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
