@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property instanceClass DB Instance available class.
 * @property price
 * @property storageRange DB Instance available storage range.
 * @property zoneIds A list of Zone to launch the DB instance.
 */
public data class GetInstanceClassesInstanceClass(
    public val instanceClass: String,
    public val price: String,
    public val storageRange: GetInstanceClassesInstanceClassStorageRange,
    public val zoneIds: List<GetInstanceClassesInstanceClassZoneId>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceClassesInstanceClass): GetInstanceClassesInstanceClass = GetInstanceClassesInstanceClass(
            instanceClass = javaType.instanceClass(),
            price = javaType.price(),
            storageRange = javaType.storageRange().let({ args0 ->
                com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassesInstanceClassStorageRange.Companion.toKotlin(args0)
            }),
            zoneIds = javaType.zoneIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassesInstanceClassZoneId.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
