@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property id The Zone to launch the DB instance
 * @property subZoneIds A list of sub zone ids which in the id - e.g If `id` is `cn-beijing-MAZ5(a,b)`, `sub_zone_ids` will be `["cn-beijing-a", "cn-beijing-b"]`.
 */
public data class GetInstanceClassesInstanceClassZoneId(
    public val id: String,
    public val subZoneIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceClassesInstanceClassZoneId): GetInstanceClassesInstanceClassZoneId = GetInstanceClassesInstanceClassZoneId(
            id = javaType.id(),
            subZoneIds = javaType.subZoneIds().map({ args0 -> args0 }),
        )
    }
}
