@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceClasses.
 * @property category
 * @property commodityCode
 * @property dbInstanceClass
 * @property dbInstanceId
 * @property dbInstanceStorageType
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Available in 1.60.0+) A list of Rds instance class codes.
 * @property instanceChargeType
 * @property instanceClasses A list of Rds available resource. Each element contains the following attributes:
 * @property multiZone
 * @property outputFile
 * @property sortedBy
 * @property storageType
 * @property zoneId
 */
public data class GetInstanceClassesResult(
    public val category: String? = null,
    public val commodityCode: String? = null,
    public val dbInstanceClass: String? = null,
    public val dbInstanceId: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String? = null,
    public val instanceClasses: List<GetInstanceClassesInstanceClass>,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
    public val sortedBy: String? = null,
    public val storageType: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceClassesResult): GetInstanceClassesResult = GetInstanceClassesResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            commodityCode = javaType.commodityCode().map({ args0 -> args0 }).orElse(null),
            dbInstanceClass = javaType.dbInstanceClass().map({ args0 -> args0 }).orElse(null),
            dbInstanceId = javaType.dbInstanceId().map({ args0 -> args0 }).orElse(null),
            dbInstanceStorageType = javaType.dbInstanceStorageType().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            instanceClasses = javaType.instanceClasses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceClassesInstanceClass.Companion.toKotlin(args0)
                })
            }),
            multiZone = javaType.multiZone().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sortedBy = javaType.sortedBy().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
