@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property category DB Instance category. the value like [`Basic`, `HighAvailability`, `Finance`, `AlwaysOn`], [detail info](https://www.alibabacloud.com/help/doc-detail/69795.htm).
 * @property engine Database type. Valid values: "MySQL", "SQLServer", "PostgreSQL", "MariaDB". If not set, it will match all of engines.
 * @property engineVersion Database version required by the user. Value options can refer to the latest docs [detail info](https://www.alibabacloud.com/help/doc-detail/26228.htm) `EngineVersion`.
 * @property zoneIds A list of Zone to launch the DB instance.
 */
public data class GetInstanceEnginesInstanceEngine(
    public val category: String,
    public val engine: String,
    public val engineVersion: String,
    public val zoneIds: List<GetInstanceEnginesInstanceEngineZoneId>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceEnginesInstanceEngine): GetInstanceEnginesInstanceEngine = GetInstanceEnginesInstanceEngine(
            category = javaType.category(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            zoneIds = javaType.zoneIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceEnginesInstanceEngineZoneId.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
