@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceEngines.
 * @property category DB Instance category.
 * @property dbInstanceStorageType
 * @property engine Database type.
 * @property engineVersion DB Instance version.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of engines.
 * @property instanceChargeType
 * @property instanceEngines A list of Rds available resource. Each element contains the following attributes:
 * @property multiZone
 * @property outputFile
 * @property zoneId
 */
public data class GetInstanceEnginesResult(
    public val category: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String? = null,
    public val instanceEngines: List<GetInstanceEnginesInstanceEngine>,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstanceEnginesResult): GetInstanceEnginesResult = GetInstanceEnginesResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            dbInstanceStorageType = javaType.dbInstanceStorageType().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
            instanceEngines = javaType.instanceEngines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstanceEnginesInstanceEngine.Companion.toKotlin(args0)
                })
            }),
            multiZone = javaType.multiZone().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
