@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property acl (Available in 1.124.1+) The method that is used to verify the identities of clients. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property availabilityZone Availability zone.
 * @property caType (Available in 1.124.1+) The type of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - aliyun: a cloud certificate
 * - custom: a custom certificate
 * @property chargeType Billing method. Value options: `Postpaid` for Pay-As-You-Go and `Prepaid` for subscription.
 * @property clientCaCert (Available in 1.124.1+) The public key of the CA that issues client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property clientCaCertExpireTime (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with cloud disks. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC. This parameter is not supported now.
 * @property clientCertRevocationList (Available in 1.124.1+) The certificate revocation list (CRL) that contains revoked client certificates. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property connectionMode `Standard` for standard access mode and `Safe` for high security access mode.
 * @property connectionString (Available in 1.70.3+) RDS database connection string.
 * @property createTime Creation time of the instance.
 * @property creator (Available in 1.124.3+) The creator of the encryption key.
 * @property dbInstanceStorageType (Available in 1.70.3+) The storage type of the instance.
 * @property dbInstanceType (Available in 1.197.0+) The type of instance.
 * @property dbType `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
 * @property deleteDate (Available in 1.124.3+) The estimated time when the encryption key will be deleted. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property deletionProtection (Available in 1.167.0+) Indicates whether the release protection feature is enabled for the instance. Valid values:
 * * **true**: The release protection feature is enabled.
 * * **false**: The release protection feature is disabled.
 * @property description (Available in 1.124.3+) The description of the encryption key.
 * @property encryptionKey (Available in 1.124.3+) The ID of the encryption key.
 * @property encryptionKeyStatus (Available in 1.124.3+) The status of the encryption key. Valid values:
 * - Enabled
 * - Disabled
 * @property engine Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
 * @property engineVersion Database version.
 * @property expireTime Expiration time. Pay-As-You-Go instances never expire.
 * @property guardInstanceId If a disaster recovery instance is attached to the current instance, the ID of the disaster recovery instance applies.
 * @property haMode (Available since v1.209.1) The high availability mode of the instance.
 * @property hostInstanceInfos (Available since v1.209.1) An array that consists of the information of the primary and secondary instances.
 * @property id The ID of the RDS instance.
 * @property instanceStorage (Available in 1.70.3+) User-defined DB instance storage space.
 * @property instanceType Sizing of the RDS instance.
 * @property keyUsage (Available in 1.124.3+) The purpose of the encryption key.
 * @property lastModifyStatus (Available in 1.124.1+) The status of the SSL link. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - success
 * - setting
 * - failed
 * @property masterInstanceId ID of the primary instance. If this parameter is not returned, the current instance is a primary instance.
 * @property masterZone (Available in 1.101.0+) The master zone of the instance.
 * @property materialExpireTime (Available in 1.124.3+) The time when the encryption key expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property modifyStatusReason (Available in 1.124.1+) The reason why the SSL link stays in the current state. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property name The name of the RDS instance.
 * @property netType `Internet` for public network or `Intranet` for private network.
 * @property origin (Available in 1.124.3+) The source of the encryption key.
 * @property parameters (Available in 1.135.0+) Parameter list.
 * @property port (Available in 1.70.3+) RDS database connection port.
 * @property readonlyInstanceIds A list of IDs of read-only instances attached to the primary instance.
 * @property regionId The region ID of the instance.
 * @property replicationAcl (Available in 1.124.1+) The method that is used to verify the replication permission. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. Valid values:
 * - cert
 * - perfer
 * - verify-ca
 * - verify-full (supported only when the instance runs PostgreSQL 12 or later)
 * @property requireUpdate (Available in 1.124.1+) Indicates whether the server certificate needs to be updated.
 * - Valid values for ApsaraDB RDS for MySQL and ApsaraDB RDS for SQL Server:
 * - No
 * - Yes
 * - Valid values for ApsaraDB RDS for PostgreSQL:
 * - 0: no
 * - 1: yes
 * @property requireUpdateItem (Available in 1.124.1+) The server certificate that needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property requireUpdateReason (Available in 1.124.1+) The reason why the server certificate needs to be updated. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property serverCaUrl (Available in 1.124.1+) The URL of the CA that issues the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property serverCert (Available in 1.124.1+) The content of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property serverKey (Available in 1.124.1+) The private key of the server certificate. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs.
 * @property sslCreateTime (Available in 1.124.1+) The time when the server certificate was created. This parameter is supported only when the instance runs PostgreSQL with standard or enhanced SSDs. In addition, this parameter is valid only when the CAType parameter is set to aliyun.
 * @property sslEnabled (Available in 1.124.1+) Indicates whether SSL encryption is enabled. Valid values:
 * - on: enabled
 * - off: disabled
 * @property sslExpireTime (Available in 1.124.1+) The time when the server certificate expires. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property status Status of the instance.
 * @property syncMode (Available since v1.209.1) The data replication mode of the instance.
 * @property tempInstanceId If a temporary instance is attached to the current instance, the ID of the temporary instance applies.
 * @property vpcId Used to retrieve instances belong to specified VPC.
 * @property vswitchId Used to retrieve instances belong to specified `vswitch` resources.
 * @property zoneIdSlaveA (Available in 1.101.0+) The region ID of the secondary instance if you create a secondary instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
 * @property zoneIdSlaveB (Available in 1.101.0+) The region ID of the log instance if you create a log instance. If you set this parameter to the same value as the ZoneId parameter, the instance is deployed in a single zone. Otherwise, the instance is deployed in multiple zones.
 */
public data class GetInstancesInstance(
    public val acl: String,
    public val availabilityZone: String,
    public val caType: String,
    public val chargeType: String,
    public val clientCaCert: String,
    public val clientCaCertExpireTime: String,
    public val clientCertRevocationList: String,
    public val connectionMode: String,
    public val connectionString: String,
    public val createTime: String,
    public val creator: String,
    public val dbInstanceStorageType: String,
    public val dbInstanceType: String,
    public val dbType: String,
    public val deleteDate: String,
    public val deletionProtection: Boolean,
    public val description: String,
    public val encryptionKey: String,
    public val encryptionKeyStatus: String,
    public val engine: String,
    public val engineVersion: String,
    public val expireTime: String,
    public val guardInstanceId: String,
    public val haMode: String,
    public val hostInstanceInfos: List<GetInstancesInstanceHostInstanceInfo>,
    public val id: String,
    public val instanceStorage: Int,
    public val instanceType: String,
    public val keyUsage: String,
    public val lastModifyStatus: String,
    public val masterInstanceId: String,
    public val masterZone: String,
    public val materialExpireTime: String,
    public val modifyStatusReason: String,
    public val name: String,
    public val netType: String,
    public val origin: String,
    public val parameters: List<GetInstancesInstanceParameter>,
    public val port: String,
    public val readonlyInstanceIds: List<String>,
    public val regionId: String,
    public val replicationAcl: String,
    public val requireUpdate: String,
    public val requireUpdateItem: String,
    public val requireUpdateReason: String,
    public val serverCaUrl: String,
    public val serverCert: String,
    public val serverKey: String,
    public val sslCreateTime: String,
    public val sslEnabled: String,
    public val sslExpireTime: String,
    public val status: String,
    public val syncMode: String,
    public val tempInstanceId: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneIdSlaveA: String,
    public val zoneIdSlaveB: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            acl = javaType.acl(),
            availabilityZone = javaType.availabilityZone(),
            caType = javaType.caType(),
            chargeType = javaType.chargeType(),
            clientCaCert = javaType.clientCaCert(),
            clientCaCertExpireTime = javaType.clientCaCertExpireTime(),
            clientCertRevocationList = javaType.clientCertRevocationList(),
            connectionMode = javaType.connectionMode(),
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            creator = javaType.creator(),
            dbInstanceStorageType = javaType.dbInstanceStorageType(),
            dbInstanceType = javaType.dbInstanceType(),
            dbType = javaType.dbType(),
            deleteDate = javaType.deleteDate(),
            deletionProtection = javaType.deletionProtection(),
            description = javaType.description(),
            encryptionKey = javaType.encryptionKey(),
            encryptionKeyStatus = javaType.encryptionKeyStatus(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            expireTime = javaType.expireTime(),
            guardInstanceId = javaType.guardInstanceId(),
            haMode = javaType.haMode(),
            hostInstanceInfos = javaType.hostInstanceInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstancesInstanceHostInstanceInfo.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceStorage = javaType.instanceStorage(),
            instanceType = javaType.instanceType(),
            keyUsage = javaType.keyUsage(),
            lastModifyStatus = javaType.lastModifyStatus(),
            masterInstanceId = javaType.masterInstanceId(),
            masterZone = javaType.masterZone(),
            materialExpireTime = javaType.materialExpireTime(),
            modifyStatusReason = javaType.modifyStatusReason(),
            name = javaType.name(),
            netType = javaType.netType(),
            origin = javaType.origin(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstancesInstanceParameter.Companion.toKotlin(args0)
                })
            }),
            port = javaType.port(),
            readonlyInstanceIds = javaType.readonlyInstanceIds().map({ args0 -> args0 }),
            regionId = javaType.regionId(),
            replicationAcl = javaType.replicationAcl(),
            requireUpdate = javaType.requireUpdate(),
            requireUpdateItem = javaType.requireUpdateItem(),
            requireUpdateReason = javaType.requireUpdateReason(),
            serverCaUrl = javaType.serverCaUrl(),
            serverCert = javaType.serverCert(),
            serverKey = javaType.serverKey(),
            sslCreateTime = javaType.sslCreateTime(),
            sslEnabled = javaType.sslEnabled(),
            sslExpireTime = javaType.sslExpireTime(),
            status = javaType.status(),
            syncMode = javaType.syncMode(),
            tempInstanceId = javaType.tempInstanceId(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneIdSlaveA = javaType.zoneIdSlaveA(),
            zoneIdSlaveB = javaType.zoneIdSlaveB(),
        )
    }
}
