@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataSyncTime The time when the secondary instance completed the synchronization of data from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property logSyncTime The time when the secondary instance received logs from the primary instance. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property nodeId The ID of the instance.
 * @property nodeType The type of the node.
 * @property regionId The region ID of the instance.
 * @property syncStatus The synchronization status.
 * @property zoneId The ID of the zone.
 */
public data class GetInstancesInstanceHostInstanceInfo(
    public val dataSyncTime: String,
    public val logSyncTime: String,
    public val nodeId: String,
    public val nodeType: String,
    public val regionId: String,
    public val syncStatus: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstancesInstanceHostInstanceInfo): GetInstancesInstanceHostInstanceInfo = GetInstancesInstanceHostInstanceInfo(
            dataSyncTime = javaType.dataSyncTime(),
            logSyncTime = javaType.logSyncTime(),
            nodeId = javaType.nodeId(),
            nodeType = javaType.nodeType(),
            regionId = javaType.regionId(),
            syncStatus = javaType.syncStatus(),
            zoneId = javaType.zoneId(),
        )
    }
}
