@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property checkingCode The value range of the parameter.
 * @property forceModify Indicates whether the parameter can be modified. Valid values: true | false
 * @property forceRestart Indicates whether the modified parameter takes effect only after a database restart. Valid values: true | false
 * @property parameterDescription The description of the parameter.
 * @property parameterName The name of the parameter.
 * @property parameterValue The default value of the parameter.
 */
public data class GetInstancesInstanceParameter(
    public val checkingCode: String,
    public val forceModify: String,
    public val forceRestart: String,
    public val parameterDescription: String,
    public val parameterName: String,
    public val parameterValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstancesInstanceParameter): GetInstancesInstanceParameter = GetInstancesInstanceParameter(
            checkingCode = javaType.checkingCode(),
            forceModify = javaType.forceModify(),
            forceRestart = javaType.forceRestart(),
            parameterDescription = javaType.parameterDescription(),
            parameterName = javaType.parameterName(),
            parameterValue = javaType.parameterValue(),
        )
    }
}
