@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInstances.
 * @property connectionMode `Standard` for standard access mode and `Safe` for high security access mode.
 * @property dbType `Primary` for primary instance, `Readonly` for read-only instance, `Guard` for disaster recovery instance, and `Temp` for temporary instance.
 * @property enableDetails
 * @property engine Database type. Options are `MySQL`, `SQLServer`, `PostgreSQL`, `MariaDB`. If no value is specified, all types are returned.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of RDS instance IDs.
 * @property instances A list of RDS instances. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of RDS instance names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status Status of the instance.
 * @property tags
 * @property totalCount
 * @property vpcId ID of the VPC the instance belongs to.
 * @property vswitchId ID of the vSwitch the instance belongs to.
 */
public data class GetInstancesResult(
    public val connectionMode: String? = null,
    public val dbType: String? = null,
    public val enableDetails: Boolean? = null,
    public val engine: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            connectionMode = javaType.connectionMode().map({ args0 -> args0 }).orElse(null),
            dbType = javaType.dbType().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
