@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property modifyTime The time when the parameter was reconfigured. This value is a UNIX timestamp. Unit: milliseconds.
 * @property newParameterValue The new value of the parameter.
 * @property oldParameterValue The original value of the parameter.
 * @property parameterName The name of the parameter.
 * @property status The status of the new value specified for the parameter. Valid values:
 * * **Applied**: The new value has taken effect.
 * * **Syncing**: The new value is being applied and has not taken effect.
 */
public data class GetModifyParameterLogsLog(
    public val modifyTime: String,
    public val newParameterValue: String,
    public val oldParameterValue: String,
    public val parameterName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetModifyParameterLogsLog): GetModifyParameterLogsLog = GetModifyParameterLogsLog(
            modifyTime = javaType.modifyTime(),
            newParameterValue = javaType.newParameterValue(),
            oldParameterValue = javaType.oldParameterValue(),
            parameterName = javaType.parameterName(),
            status = javaType.status(),
        )
    }
}
