@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getModifyParameterLogs.
 * @property dbInstanceId
 * @property endTime
 * @property id The provider-assigned unique ID for this managed resource.
 * @property logs
 * @property outputFile
 * @property startTime
 */
public data class GetModifyParameterLogsResult(
    public val dbInstanceId: String,
    public val endTime: String,
    public val id: String,
    public val logs: List<GetModifyParameterLogsLog>,
    public val outputFile: String? = null,
    public val startTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetModifyParameterLogsResult): GetModifyParameterLogsResult = GetModifyParameterLogsResult(
            dbInstanceId = javaType.dbInstanceId(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetModifyParameterLogsLog.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime(),
        )
    }
}
