@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backupDownloadUrl The backup download url.
 * @property backupEndTime BackupEndTime.
 * @property backupId BackupId.
 * @property backupInitiator The initiator of the backup task. Value:
 * * **System**: automatically initiated by the System
 * * **User**: manually initiated by the User.
 * @property backupIntranetDownloadUrl The backup intranet download url.
 * @property backupMethod BackupMethod.
 * @property backupMode BackupMode.
 * @property backupSize BackupSize.
 * @property backupStartTime BackupStartTime.
 * @property backupStatus Backup task status. **NOTE:** This parameter will only be returned when a task is executed. Value:
 * * **NoStart**: Not started
 * * **Checking**: check the backup
 * * **Preparing**: Prepare a backup
 * * **Waiting**: Waiting for backup
 * * **Uploading**: Upload backup
 * * **Finished**: Complete backup
 * * **Failed**: backup Failed
 * @property backupType BackupType.
 * @property consistentTime The consistency point of the backup set. The return value is a timestamp. **NOTE:** only MySQL 5.6 returns this parameter, and other versions return 0.
 * @property copyOnlyBackup The backup mode is divided into the normal backup mode (full and incremental recovery is supported) and the replication-only mode (full recovery is supported only). **NOTE:** Only SQL Server returns this parameter. Valid values:
 * * **0**: General Backup Mode
 * * **1**: Copy only mode
 * @property dbInstanceId The db instance id.
 * @property encryption The encrypted information of the backup set.
 * @property hostInstanceId HostInstanceID.
 * @property id The ID of the Backup.
 * @property isAvail Whether the backup set is available, the value is:
 * * **0**: Not available
 * * **1**: Available.
 * @property metaStatus The backup set status of the database table. **NOTE:** an empty string indicates that the backup set for database table recovery is not enabled. Valid values:
 * * **OK**: normal.
 * * **LARGE**: There are too many tables that cannot be used for database and table recovery.
 * * **EMPTY**: The backup set that failed to be backed up.
 * @property storageClass The storage medium for the backup set. Valid values:
 * * **0**: Regular storage
 * * **1**: Archive storage.
 * @property storeStatus StoreStatus.
 */
public data class GetRdsBackupsBackup(
    public val backupDownloadUrl: String,
    public val backupEndTime: String,
    public val backupId: String,
    public val backupInitiator: String,
    public val backupIntranetDownloadUrl: String,
    public val backupMethod: String,
    public val backupMode: String,
    public val backupSize: String,
    public val backupStartTime: String,
    public val backupStatus: String,
    public val backupType: String,
    public val consistentTime: String,
    public val copyOnlyBackup: String,
    public val dbInstanceId: String,
    public val encryption: String,
    public val hostInstanceId: String,
    public val id: String,
    public val isAvail: Int,
    public val metaStatus: String,
    public val storageClass: String,
    public val storeStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetRdsBackupsBackup): GetRdsBackupsBackup = GetRdsBackupsBackup(
            backupDownloadUrl = javaType.backupDownloadUrl(),
            backupEndTime = javaType.backupEndTime(),
            backupId = javaType.backupId(),
            backupInitiator = javaType.backupInitiator(),
            backupIntranetDownloadUrl = javaType.backupIntranetDownloadUrl(),
            backupMethod = javaType.backupMethod(),
            backupMode = javaType.backupMode(),
            backupSize = javaType.backupSize(),
            backupStartTime = javaType.backupStartTime(),
            backupStatus = javaType.backupStatus(),
            backupType = javaType.backupType(),
            consistentTime = javaType.consistentTime(),
            copyOnlyBackup = javaType.copyOnlyBackup(),
            dbInstanceId = javaType.dbInstanceId(),
            encryption = javaType.encryption(),
            hostInstanceId = javaType.hostInstanceId(),
            id = javaType.id(),
            isAvail = javaType.isAvail(),
            metaStatus = javaType.metaStatus(),
            storageClass = javaType.storageClass(),
            storeStatus = javaType.storeStatus(),
        )
    }
}
