@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRdsBackups.
 * @property backupMode
 * @property backupStatus
 * @property backups
 * @property dbInstanceId
 * @property endTime
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property startTime
 */
public data class GetRdsBackupsResult(
    public val backupMode: String? = null,
    public val backupStatus: String? = null,
    public val backups: List<GetRdsBackupsBackup>,
    public val dbInstanceId: String,
    public val endTime: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetRdsBackupsResult): GetRdsBackupsResult = GetRdsBackupsResult(
            backupMode = javaType.backupMode().map({ args0 -> args0 }).orElse(null),
            backupStatus = javaType.backupStatus().map({ args0 -> args0 }).orElse(null),
            backups = javaType.backups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetRdsBackupsBackup.Companion.toKotlin(args0)
                })
            }),
            dbInstanceId = javaType.dbInstanceId(),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
