@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property engine
 * @property engineVersion
 * @property forceRestart
 * @property id
 * @property paramCounts
 * @property paramDetails
 * @property parameterGroupDesc
 * @property parameterGroupId
 * @property parameterGroupName
 * @property parameterGroupType
 */
public data class GetRdsParameterGroupsGroup(
    public val engine: String,
    public val engineVersion: String,
    public val forceRestart: Int,
    public val id: String,
    public val paramCounts: Int,
    public val paramDetails: List<GetRdsParameterGroupsGroupParamDetail>,
    public val parameterGroupDesc: String,
    public val parameterGroupId: String,
    public val parameterGroupName: String,
    public val parameterGroupType: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetRdsParameterGroupsGroup): GetRdsParameterGroupsGroup = GetRdsParameterGroupsGroup(
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            forceRestart = javaType.forceRestart(),
            id = javaType.id(),
            paramCounts = javaType.paramCounts(),
            paramDetails = javaType.paramDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.rds.kotlin.outputs.GetRdsParameterGroupsGroupParamDetail.Companion.toKotlin(args0)
                })
            }),
            parameterGroupDesc = javaType.parameterGroupDesc(),
            parameterGroupId = javaType.parameterGroupId(),
            parameterGroupName = javaType.parameterGroupName(),
            parameterGroupType = javaType.parameterGroupType(),
        )
    }
}
