@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSlots.
 * @property dbInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property resourceGroupId
 * @property slots A list of Rds Replication Slots. Each element contains the following attributes:
 */
public data class GetSlotsResult(
    public val dbInstanceId: String,
    public val id: String,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val slots: List<GetSlotsSlot>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetSlotsResult): GetSlotsResult =
            GetSlotsResult(
                dbInstanceId = javaType.dbInstanceId(),
                id = javaType.id(),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
                slots = javaType.slots().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.rds.kotlin.outputs.GetSlotsSlot.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
