@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property database The name of the database where Replication Slot is located.
 * @property plugin The plugin used by Replication Slot.
 * @property slotName The Replication Slot name.
 * @property slotStatus The Replication Slot status.
 * @property slotType The Replication Slot type.
 * @property temporary Is the Replication Slot temporary.
 * @property walDelay The amount of logs accumulated by Replication Slot.
 */
public data class GetSlotsSlot(
    public val database: String,
    public val plugin: String,
    public val slotName: String,
    public val slotStatus: String,
    public val slotType: String,
    public val temporary: String,
    public val walDelay: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetSlotsSlot): GetSlotsSlot =
            GetSlotsSlot(
                database = javaType.database(),
                plugin = javaType.plugin(),
                slotName = javaType.slotName(),
                slotStatus = javaType.slotStatus(),
                slotType = javaType.slotType(),
                temporary = javaType.temporary(),
                walDelay = javaType.walDelay(),
            )
    }
}
