@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getZones.
 * @property category
 * @property dbInstanceStorageType
 * @property engine
 * @property engineVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of zone IDs.
 * @property instanceChargeType
 * @property multi
 * @property multiZone
 * @property outputFile
 * @property zones A list of availability zones. Each element contains the following attributes:
 */
public data class GetZonesResult(
    public val category: String? = null,
    public val dbInstanceStorageType: String? = null,
    public val engine: String? = null,
    public val engineVersion: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceChargeType: String? = null,
    @Deprecated(
        message = """
  It has been deprecated from version 1.137.0 and using `multi_zone` instead.
  """,
    )
    public val multi: Boolean? = null,
    public val multiZone: Boolean? = null,
    public val outputFile: String? = null,
    public val zones: List<GetZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.GetZonesResult): GetZonesResult =
            GetZonesResult(
                category = javaType.category().map({ args0 -> args0 }).orElse(null),
                dbInstanceStorageType = javaType.dbInstanceStorageType().map({ args0 -> args0 }).orElse(null),
                engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
                engineVersion = javaType.engineVersion().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                instanceChargeType = javaType.instanceChargeType().map({ args0 -> args0 }).orElse(null),
                multi = javaType.multi().map({ args0 -> args0 }).orElse(null),
                multiZone = javaType.multiZone().map({ args0 -> args0 }).orElse(null),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                zones = javaType.zones().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.rds.kotlin.outputs.GetZonesZone.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
