@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property babelfishEnabled specifies whether to enable the Babelfish for the instance. If you set this parameter to **true**, you enable Babelfish for the instance. If you leave this parameter empty, you disable Babelfish for the instance.
 * @property masterUserPassword The password of the administrator account. The password must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. It must be 8 to 32 characters in length. The password can contain any of the following characters:! @ # $ % ^ & * () _ + - =
 * @property masterUsername The name of the administrator account. The name can contain lowercase letters, digits, and underscores (_). It must start with a letter and end with a letter or digit. It can be up to 63 characters in length and cannot start with pg.
 * @property migrationMode The migration mode of the instance. Valid values: **single-db** and **multi-db**.
 */
public data class InstanceBabelfishConfig(
    public val babelfishEnabled: String,
    public val masterUserPassword: String,
    public val masterUsername: String,
    public val migrationMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.InstanceBabelfishConfig): InstanceBabelfishConfig = InstanceBabelfishConfig(
            babelfishEnabled = javaType.babelfishEnabled(),
            masterUserPassword = javaType.masterUserPassword(),
            masterUsername = javaType.masterUsername(),
            migrationMode = javaType.migrationMode(),
        )
    }
}
