@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The IP addresses from which the specified users can access the specified databases. If you set this parameter to 0.0.0.0/0, the specified users are allowed to access the specified databases from all IP addresses.
 * @property database The name of the database that the specified users are allowed to access. If you set this parameter to all, the specified users are allowed to access all databases in the instance. If you specify multiple databases, separate the database names with commas (,).
 * @property mask The mask of the instance. If the value of the `Address` parameter is an IP address, you can use this parameter to specify the mask of the IP address.
 * @property method The authentication method of Lightweight Directory Access Protocol (LDAP). Valid values: `trust`, `reject`, `scram-sha-256`, `md5`, `password`, `gss`, `sspi`, `ldap`, `radius`, `cert`, `pam`.
 * @property option Optional. The value of this parameter is based on the value of the HbaItem.N.Method parameter. In this topic, LDAP is used as an example. You must configure this parameter. For more information, see [Authentication Methods](https://www.postgresql.org/docs/11/auth-methods.html).
 * @property priorityId The priority of an AD domain. If you set this parameter to 0, the AD domain has the highest priority. Valid values: 0 to 10000. This parameter is used to identify each AD domain. When you add an AD domain, the value of the PriorityId parameter of the new AD domain cannot be the same as the value of the PriorityId parameter for any existing AD domain. When you modify or delete an AD domain, you must also modify or delete the value of the PriorityId parameter for this AD domain.
 * @property type The type of connection to the instance. Valid values:
 * * **host**: specifies to verify TCP/IP connections, including SSL connections and non-SSL connections.
 * * **hostssl**: specifies to verify only TCP/IP connections that are established over SSL connections.
 * * **hostnossl**: specifies to verify only TCP/IP connections that are established over non-SSL connections.
 * > **NOTE:** You can set this parameter to hostssl only when SSL encryption is enabled for the instance. For more information, see [Configure SSL encryption for an ApsaraDB RDS for PostgreSQL instance](https://www.alibabacloud.com/help/en/doc-detail/229518.htm).
 * @property user The user that is allowed to access the instance. If you specify multiple users, separate the usernames with commas (,).
 */
public data class InstancePgHbaConf(
    public val address: String,
    public val database: String,
    public val mask: String? = null,
    public val method: String,
    public val option: String? = null,
    public val priorityId: Int,
    public val type: String,
    public val user: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.InstancePgHbaConf): InstancePgHbaConf = InstancePgHbaConf(
            address = javaType.address(),
            database = javaType.database(),
            mask = javaType.mask().map({ args0 -> args0 }).orElse(null),
            method = javaType.method(),
            option = javaType.option().map({ args0 -> args0 }).orElse(null),
            priorityId = javaType.priorityId(),
            type = javaType.type(),
            user = javaType.user(),
        )
    }
}
