@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property autoPause
 * @property maxCapacity The maximum number of RDS Capacity Units (RCUs). The value of this parameter must be greater than or equal to `min_capacity` and only supports passing integers. Valid values:
 * - MySQL: 1~8
 * - SQLServer: 2~8
 * - PostgreSQL: 1~12
 * @property minCapacity The minimum number of RCUs. The value of this parameter must be less than or equal to `max_capacity`. Valid values:
 * - MySQL: 0.5~8
 * - SQLServer: 2~8 \(Supports integers only\).
 * - PostgreSQL: 0.5~12
 * @property switchForce Specifies whether to enable the forced scaling feature for the serverless instance. Valid values:
 * - true: enables the feature.
 * - false: disables the feature. This is the default value.
 * > - Only MySQL Serverless instances need to set this parameter. After enabling this parameter, there will be a flash break within 1 minute when the instance is forced to expand or shrink. Please use it with caution according to the actual situation.
 * > - The elastic scaling of an instance RCU usually takes effect immediately, but in some special circumstances (such as during large transaction execution), it is not possible to complete scaling immediately. In this case, this parameter can be enabled to force scaling.
 */
public data class InstanceServerlessConfig(
    public val autoPause: Boolean? = null,
    public val maxCapacity: Double,
    public val minCapacity: Double,
    public val switchForce: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.InstanceServerlessConfig): InstanceServerlessConfig = InstanceServerlessConfig(
            autoPause = javaType.autoPause().map({ args0 -> args0 }).orElse(null),
            maxCapacity = javaType.maxCapacity(),
            minCapacity = javaType.minCapacity(),
            switchForce = javaType.switchForce().map({ args0 -> args0 }).orElse(null),
        )
    }
}
