@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceId The Id of the instance and its read-only instances that can run database.
 * @property weight Weight of instances that can run the database and their read-only instances. Read weights increase in increments of 100, and the maximum read weight is 10000.
 */
public data class RdsDbProxyReadOnlyInstanceWeight(
    public val instanceId: String,
    public val weight: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.rds.outputs.RdsDbProxyReadOnlyInstanceWeight): RdsDbProxyReadOnlyInstanceWeight = RdsDbProxyReadOnlyInstanceWeight(
            instanceId = javaType.instanceId(),
            weight = javaType.weight(),
        )
    }
}
