@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.realtimecompute.kotlin

import com.pulumi.alicloud.realtimecompute.kotlin.outputs.VvpInstanceResourceSpec
import com.pulumi.alicloud.realtimecompute.kotlin.outputs.VvpInstanceStorage
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.realtimecompute.kotlin.outputs.VvpInstanceResourceSpec.Companion.toKotlin as vvpInstanceResourceSpecToKotlin
import com.pulumi.alicloud.realtimecompute.kotlin.outputs.VvpInstanceStorage.Companion.toKotlin as vvpInstanceStorageToKotlin

/**
 * Builder for [VvpInstance].
 */
@PulumiTagMarker
public class VvpInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VvpInstanceArgs = VvpInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VvpInstanceArgsBuilder.() -> Unit) {
        val builder = VvpInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VvpInstance {
        val builtJavaResource = com.pulumi.alicloud.realtimecompute.VvpInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VvpInstance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Realtime Compute Vvp Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:realtimecompute/vvpInstance:VvpInstance example <id>
 * ```
 */
public class VvpInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.realtimecompute.VvpInstance,
) : KotlinCustomResource(javaResource, VvpInstanceMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The number of subscription periods. If the payment type is PRE, this parameter is required.
     */
    public val duration: Output<Int>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type of the resource.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The subscription period. If the payment type is PRE, this parameter is required.
     */
    public val pricingCycle: Output<String>?
        get() = javaResource.pricingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group to which the newly purchased instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Resource specifications. See `resource_spec` below.
     */
    public val resourceSpec: Output<VvpInstanceResourceSpec>
        get() = javaResource.resourceSpec().applyValue({ args0 ->
            args0.let({ args0 ->
                vvpInstanceResourceSpecToKotlin(args0)
            })
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Store information. See `storage` below.
     */
    public val storage: Output<VvpInstanceStorage>
        get() = javaResource.storage().applyValue({ args0 ->
            args0.let({ args0 ->
                vvpInstanceStorageToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VPC ID of the user.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * Virtual Switch ID.
     */
    public val vswitchIds: Output<List<String>>
        get() = javaResource.vswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the workspace.
     */
    public val vvpInstanceName: Output<String>
        get() = javaResource.vvpInstanceName().applyValue({ args0 -> args0 })

    /**
     * The zone ID of the resource.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object VvpInstanceMapper : ResourceMapper<VvpInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.realtimecompute.VvpInstance::class == javaResource::class

    override fun map(javaResource: Resource): VvpInstance = VvpInstance(
        javaResource as
            com.pulumi.alicloud.realtimecompute.VvpInstance,
    )
}

/**
 * @see [VvpInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VvpInstance].
 */
public suspend fun vvpInstance(name: String, block: suspend VvpInstanceResourceBuilder.() -> Unit): VvpInstance {
    val builder = VvpInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VvpInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vvpInstance(name: String): VvpInstance {
    val builder = VvpInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
