@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.realtimecompute.kotlin

import com.pulumi.alicloud.realtimecompute.VvpInstanceArgs.builder
import com.pulumi.alicloud.realtimecompute.kotlin.inputs.VvpInstanceResourceSpecArgs
import com.pulumi.alicloud.realtimecompute.kotlin.inputs.VvpInstanceResourceSpecArgsBuilder
import com.pulumi.alicloud.realtimecompute.kotlin.inputs.VvpInstanceStorageArgs
import com.pulumi.alicloud.realtimecompute.kotlin.inputs.VvpInstanceStorageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Realtime Compute Vvp Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:realtimecompute/vvpInstance:VvpInstance example <id>
 * ```
 * @property duration The number of subscription periods. If the payment type is PRE, this parameter is required.
 * @property paymentType The payment type of the resource.
 * @property pricingCycle The subscription period. If the payment type is PRE, this parameter is required.
 * @property resourceGroupId The resource group to which the newly purchased instance belongs.
 * @property resourceSpec Resource specifications. See `resource_spec` below.
 * @property storage Store information. See `storage` below.
 * @property tags The tags of the resource.
 * @property vpcId The VPC ID of the user.
 * @property vswitchIds Virtual Switch ID.
 * @property vvpInstanceName The name of the workspace.
 * @property zoneId The zone ID of the resource.
 */
public data class VvpInstanceArgs(
    public val duration: Output<Int>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val resourceSpec: Output<VvpInstanceResourceSpecArgs>? = null,
    public val storage: Output<VvpInstanceStorageArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
    public val vvpInstanceName: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.realtimecompute.VvpInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.realtimecompute.VvpInstanceArgs =
        com.pulumi.alicloud.realtimecompute.VvpInstanceArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .resourceSpec(resourceSpec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storage(storage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vvpInstanceName(vvpInstanceName?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VvpInstanceArgs].
 */
@PulumiTagMarker
public class VvpInstanceArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var resourceSpec: Output<VvpInstanceResourceSpecArgs>? = null

    private var storage: Output<VvpInstanceStorageArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    private var vvpInstanceName: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The number of subscription periods. If the payment type is PRE, this parameter is required.
     */
    @JvmName("lfnedvqyryagyryb")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("rvlahmutfhmwfihs")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The subscription period. If the payment type is PRE, this parameter is required.
     */
    @JvmName("gydftjhmnfnhvsfi")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The resource group to which the newly purchased instance belongs.
     */
    @JvmName("wbyymhbmoyqwccwx")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Resource specifications. See `resource_spec` below.
     */
    @JvmName("abesjalgucboqbyl")
    public suspend fun resourceSpec(`value`: Output<VvpInstanceResourceSpecArgs>) {
        this.resourceSpec = value
    }

    /**
     * @param value Store information. See `storage` below.
     */
    @JvmName("tjmxaeqsobaisgsf")
    public suspend fun storage(`value`: Output<VvpInstanceStorageArgs>) {
        this.storage = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("uxjvrrsudcodwanq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID of the user.
     */
    @JvmName("ilylejedgxhjyfho")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Virtual Switch ID.
     */
    @JvmName("ginwyfmygitanhak")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("nevoxftojtbhnbiw")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values Virtual Switch ID.
     */
    @JvmName("nxrwlnrtopsjcnvr")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xtrecrxbbgsstxgf")
    public suspend fun vvpInstanceName(`value`: Output<String>) {
        this.vvpInstanceName = value
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("bvgkanonhilavvmd")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The number of subscription periods. If the payment type is PRE, this parameter is required.
     */
    @JvmName("wiqcsiccdbjtmymf")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("vejvdndqmgdsidfo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The subscription period. If the payment type is PRE, this parameter is required.
     */
    @JvmName("xehfqhducpfrdmqq")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The resource group to which the newly purchased instance belongs.
     */
    @JvmName("xtujiignwbvtpfob")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Resource specifications. See `resource_spec` below.
     */
    @JvmName("ggsvoesfiynnqaem")
    public suspend fun resourceSpec(`value`: VvpInstanceResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSpec = mapped
    }

    /**
     * @param argument Resource specifications. See `resource_spec` below.
     */
    @JvmName("ufxffspupekprpem")
    public suspend fun resourceSpec(argument: suspend VvpInstanceResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped = VvpInstanceResourceSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceSpec = mapped
    }

    /**
     * @param value Store information. See `storage` below.
     */
    @JvmName("cajvanxwttmdoscj")
    public suspend fun storage(`value`: VvpInstanceStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param argument Store information. See `storage` below.
     */
    @JvmName("gmwhqlxdopqsbxuo")
    public suspend fun storage(argument: suspend VvpInstanceStorageArgsBuilder.() -> Unit) {
        val toBeMapped = VvpInstanceStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storage = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("fiqhlaemmfivwxyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("qmydbuofscbxxpqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID of the user.
     */
    @JvmName("ytitlmggkehxbfom")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Virtual Switch ID.
     */
    @JvmName("unnomgeqvjourwdr")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values Virtual Switch ID.
     */
    @JvmName("kuusiwpxradjqagk")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("qmvxwgvsjnjutpos")
    public suspend fun vvpInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vvpInstanceName = mapped
    }

    /**
     * @param value The zone ID of the resource.
     */
    @JvmName("cwaavlqwfpdbrvsc")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): VvpInstanceArgs = VvpInstanceArgs(
        duration = duration,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        resourceGroupId = resourceGroupId,
        resourceSpec = resourceSpec,
        storage = storage,
        tags = tags,
        vpcId = vpcId,
        vswitchIds = vswitchIds,
        vvpInstanceName = vvpInstanceName,
        zoneId = zoneId,
    )
}
