@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.realtimecompute.kotlin.inputs

import com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceResourceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu CPU number.
 * @property memoryGb Memory size.
 */
public data class VvpInstanceResourceSpecArgs(
    public val cpu: Output<Int>? = null,
    public val memoryGb: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceResourceSpecArgs> {
    override fun toJava(): com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceResourceSpecArgs =
        com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceResourceSpecArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memoryGb(memoryGb?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VvpInstanceResourceSpecArgs].
 */
@PulumiTagMarker
public class VvpInstanceResourceSpecArgsBuilder internal constructor() {
    private var cpu: Output<Int>? = null

    private var memoryGb: Output<Int>? = null

    /**
     * @param value CPU number.
     */
    @JvmName("qmqthuhrxghvfqwn")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value Memory size.
     */
    @JvmName("ugdncspuxwxrqkwj")
    public suspend fun memoryGb(`value`: Output<Int>) {
        this.memoryGb = value
    }

    /**
     * @param value CPU number.
     */
    @JvmName("qptswnhycxuuybhg")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Memory size.
     */
    @JvmName("lkqyrdbikkkvbjqk")
    public suspend fun memoryGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryGb = mapped
    }

    internal fun build(): VvpInstanceResourceSpecArgs = VvpInstanceResourceSpecArgs(
        cpu = cpu,
        memoryGb = memoryGb,
    )
}
