@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.realtimecompute.kotlin.inputs

import com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property oss OSS stores information. See `oss` below.
 */
public data class VvpInstanceStorageArgs(
    public val oss: Output<VvpInstanceStorageOssArgs>,
) : ConvertibleToJava<com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageArgs> {
    override fun toJava(): com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageArgs =
        com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageArgs.builder()
            .oss(oss.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VvpInstanceStorageArgs].
 */
@PulumiTagMarker
public class VvpInstanceStorageArgsBuilder internal constructor() {
    private var oss: Output<VvpInstanceStorageOssArgs>? = null

    /**
     * @param value OSS stores information. See `oss` below.
     */
    @JvmName("rpctxtenvsenwnjv")
    public suspend fun oss(`value`: Output<VvpInstanceStorageOssArgs>) {
        this.oss = value
    }

    /**
     * @param value OSS stores information. See `oss` below.
     */
    @JvmName("mjfxuxgpvlrcuavd")
    public suspend fun oss(`value`: VvpInstanceStorageOssArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oss = mapped
    }

    /**
     * @param argument OSS stores information. See `oss` below.
     */
    @JvmName("jmnnyflrqocdasac")
    public suspend fun oss(argument: suspend VvpInstanceStorageOssArgsBuilder.() -> Unit) {
        val toBeMapped = VvpInstanceStorageOssArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oss = mapped
    }

    internal fun build(): VvpInstanceStorageArgs = VvpInstanceStorageArgs(
        oss = oss ?: throw PulumiNullFieldException("oss"),
    )
}
