@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.realtimecompute.kotlin.inputs

import com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageOssArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket OSS Bucket name.
 */
public data class VvpInstanceStorageOssArgs(
    public val bucket: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageOssArgs> {
    override fun toJava(): com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageOssArgs =
        com.pulumi.alicloud.realtimecompute.inputs.VvpInstanceStorageOssArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VvpInstanceStorageOssArgs].
 */
@PulumiTagMarker
public class VvpInstanceStorageOssArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    /**
     * @param value OSS Bucket name.
     */
    @JvmName("adheiketjviempcv")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value OSS Bucket name.
     */
    @JvmName("tviuyeffmbhbhysi")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    internal fun build(): VvpInstanceStorageOssArgs = VvpInstanceStorageOssArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
    )
}
