@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.redis.kotlin

import com.pulumi.alicloud.redis.TairInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Redis Tair Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:redis/tairInstance:TairInstance example <id>
 * ```
 * @property autoRenew Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
 * @property autoRenewPeriod The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
 * @property clusterBackupId The ID of the backup set of the cluster.
 * @property effectiveTime The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
 * @property engineVersion Database version. Default value: 1.0. Rules for transferring parameters of different tair product types: tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0. tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0. tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
 * @property forceUpgrade Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
 * @property instanceClass The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
 * @property instanceType The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
 * @property nodeType Node type, value: MASTER_SLAVE: high availability (dual copy) STAND_ALONE: single copy double: double copy single: single copy Note For Cloud Native instances, select MASTER_SLAVE or STAND_ALONE. For Classic instances, select double or single.
 * @property password The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
 * @property paymentType Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo. Since version 1.227.0, you can transfer prepaid instance to postpaid.
 * @property period The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
 * @property port The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
 * @property readOnlyCount Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions: If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture. If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property secondaryZoneId The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
 * @property securityGroupId Security group ID
 * @property shardCount The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
 * @property slaveReadOnlyCount Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance. Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
 * @property sslEnabled Modify the TLS(SSL) setting. Value: Expand Details Example values: Enable Enumeration value: Disable Enable Update Reference value Source: DescribeInstanceSSL
 * @property storagePerformanceLevel The storage type. The value is set to essd_pl1. Note This parameter is only available when the value of InstanceType is tair_essd.
 * @property storageSizeGb The value range of different specifications is different, see [ESSD-based instances](https://www.alibabacloud.com/help/en/tair/product-overview/essd-based-instances). When the value of instance_type is "tair_essd", this attribute takes effect and is required.
 * @property tags The tag of the resource
 * @property tairInstanceName The name of the resource.
 * @property vpcId The ID of the virtual private cloud (VPC).
 * @property vswitchId The ID of the vSwitch to which the instance is connected.
 * @property zoneId Zone ID
 */
public data class TairInstanceArgs(
    public val autoRenew: Output<String>? = null,
    public val autoRenewPeriod: Output<String>? = null,
    public val clusterBackupId: Output<String>? = null,
    public val effectiveTime: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val forceUpgrade: Output<Boolean>? = null,
    public val instanceClass: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val nodeType: Output<String>? = null,
    public val password: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val readOnlyCount: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val secondaryZoneId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val shardCount: Output<Int>? = null,
    public val slaveReadOnlyCount: Output<Int>? = null,
    public val sslEnabled: Output<String>? = null,
    public val storagePerformanceLevel: Output<String>? = null,
    public val storageSizeGb: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tairInstanceName: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.redis.TairInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.redis.TairInstanceArgs =
        com.pulumi.alicloud.redis.TairInstanceArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .clusterBackupId(clusterBackupId?.applyValue({ args0 -> args0 }))
            .effectiveTime(effectiveTime?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .forceUpgrade(forceUpgrade?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .nodeType(nodeType?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .readOnlyCount(readOnlyCount?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .secondaryZoneId(secondaryZoneId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 }))
            .slaveReadOnlyCount(slaveReadOnlyCount?.applyValue({ args0 -> args0 }))
            .sslEnabled(sslEnabled?.applyValue({ args0 -> args0 }))
            .storagePerformanceLevel(storagePerformanceLevel?.applyValue({ args0 -> args0 }))
            .storageSizeGb(storageSizeGb?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tairInstanceName(tairInstanceName?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TairInstanceArgs].
 */
@PulumiTagMarker
public class TairInstanceArgsBuilder internal constructor() {
    private var autoRenew: Output<String>? = null

    private var autoRenewPeriod: Output<String>? = null

    private var clusterBackupId: Output<String>? = null

    private var effectiveTime: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var forceUpgrade: Output<Boolean>? = null

    private var instanceClass: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var nodeType: Output<String>? = null

    private var password: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var port: Output<Int>? = null

    private var readOnlyCount: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var secondaryZoneId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var shardCount: Output<Int>? = null

    private var slaveReadOnlyCount: Output<Int>? = null

    private var sslEnabled: Output<String>? = null

    private var storagePerformanceLevel: Output<String>? = null

    private var storageSizeGb: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tairInstanceName: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
     */
    @JvmName("fykwpmhdbamldifu")
    public suspend fun autoRenew(`value`: Output<String>) {
        this.autoRenew = value
    }

    /**
     * @param value The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
     */
    @JvmName("kuicfqmkftusambg")
    public suspend fun autoRenewPeriod(`value`: Output<String>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value The ID of the backup set of the cluster.
     */
    @JvmName("vevnpfhiffueglxb")
    public suspend fun clusterBackupId(`value`: Output<String>) {
        this.clusterBackupId = value
    }

    /**
     * @param value The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
     */
    @JvmName("enjhqbheowjpdhrc")
    public suspend fun effectiveTime(`value`: Output<String>) {
        this.effectiveTime = value
    }

    /**
     * @param value Database version. Default value: 1.0. Rules for transferring parameters of different tair product types: tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0. tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0. tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
     */
    @JvmName("wayjdbypvtnkjabe")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
     */
    @JvmName("xembkakfurrounuj")
    public suspend fun forceUpgrade(`value`: Output<Boolean>) {
        this.forceUpgrade = value
    }

    /**
     * @param value The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
     */
    @JvmName("hbipghnyutagguyp")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
     */
    @JvmName("antwfyqjkirwiqjq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Node type, value: MASTER_SLAVE: high availability (dual copy) STAND_ALONE: single copy double: double copy single: single copy Note For Cloud Native instances, select MASTER_SLAVE or STAND_ALONE. For Classic instances, select double or single.
     */
    @JvmName("vmcgblogymqhbklv")
    public suspend fun nodeType(`value`: Output<String>) {
        this.nodeType = value
    }

    /**
     * @param value The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
     */
    @JvmName("vnjhtvuqndrlhxad")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo. Since version 1.227.0, you can transfer prepaid instance to postpaid.
     */
    @JvmName("jsegkyekldjgjtla")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
     */
    @JvmName("kaikyhmmbvhrdbbf")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
     */
    @JvmName("sfiislidtomdhsug")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions: If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture. If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
     */
    @JvmName("xxnlasmxfenxrpmp")
    public suspend fun readOnlyCount(`value`: Output<Int>) {
        this.readOnlyCount = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("apnxjraionugqvri")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
     */
    @JvmName("jndhmbcoumfrfofm")
    public suspend fun secondaryZoneId(`value`: Output<String>) {
        this.secondaryZoneId = value
    }

    /**
     * @param value Security group ID
     */
    @JvmName("ocicqyicqkiqqlyy")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
     */
    @JvmName("juvtebacbtcepsks")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance. Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
     */
    @JvmName("vxdgkesucwjeoeqp")
    public suspend fun slaveReadOnlyCount(`value`: Output<Int>) {
        this.slaveReadOnlyCount = value
    }

    /**
     * @param value Modify the TLS(SSL) setting. Value: Expand Details Example values: Enable Enumeration value: Disable Enable Update Reference value Source: DescribeInstanceSSL
     */
    @JvmName("kmeusxoyyvwlbrwp")
    public suspend fun sslEnabled(`value`: Output<String>) {
        this.sslEnabled = value
    }

    /**
     * @param value The storage type. The value is set to essd_pl1. Note This parameter is only available when the value of InstanceType is tair_essd.
     */
    @JvmName("rowtjvdnxbxlfvdj")
    public suspend fun storagePerformanceLevel(`value`: Output<String>) {
        this.storagePerformanceLevel = value
    }

    /**
     * @param value The value range of different specifications is different, see [ESSD-based instances](https://www.alibabacloud.com/help/en/tair/product-overview/essd-based-instances). When the value of instance_type is "tair_essd", this attribute takes effect and is required.
     */
    @JvmName("klghilrfxhxtvxsm")
    public suspend fun storageSizeGb(`value`: Output<Int>) {
        this.storageSizeGb = value
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("taanuqnyuswostlu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("fkjmqyhytyrbwgir")
    public suspend fun tairInstanceName(`value`: Output<String>) {
        this.tairInstanceName = value
    }

    /**
     * @param value The ID of the virtual private cloud (VPC).
     */
    @JvmName("dkjckwyydmialyav")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the vSwitch to which the instance is connected.
     */
    @JvmName("ucjrkfqwnmmymrrf")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Zone ID
     */
    @JvmName("jochtvbbvnkvdqlu")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Specifies whether to enable auto-renewal for the instance. Default value: false. Valid values: true(enables auto-renewal), false(disables auto-renewal).
     */
    @JvmName("dhscvteaoqeudbkc")
    public suspend fun autoRenew(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The subscription duration that is supported by auto-renewal. Unit: months. Valid values: 1, 2, 3, 6, and 12. This parameter is required only if the AutoRenew parameter is set to true.
     */
    @JvmName("bvurqkjfkkdiosyd")
    public suspend fun autoRenewPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value The ID of the backup set of the cluster.
     */
    @JvmName("kmtrqwhjbbxbrbrw")
    public suspend fun clusterBackupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterBackupId = mapped
    }

    /**
     * @param value The time when to change the configurations. Default value: Immediately. Valid values: Immediately (The configurations are immediately changed), MaintainTime (The configurations are changed within the maintenance window).
     */
    @JvmName("twqocgqgahebaqar")
    public suspend fun effectiveTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveTime = mapped
    }

    /**
     * @param value Database version. Default value: 1.0. Rules for transferring parameters of different tair product types: tair_rdb:  Compatible with the Redis5.0 and Redis6.0 protocols, and is transmitted to 5.0 or 6.0. tair_scm: The Tair persistent memory is compatible with the Redis6.0 protocol and is passed 1.0. tair_essd: The disk (ESSD/SSD) is compatible with the Redis4.0 and Redis6.0 protocols, and is transmitted to 1.0 and 2.0 respectively.
     */
    @JvmName("yftikohssgkxdorm")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value Specifies whether to forcefully change the configurations of the instance. Default value: true. Valid values: false (The system does not forcefully change the configurations), true (The system forcefully changes the configurations).
     */
    @JvmName("witvwlopkxhjgvsc")
    public suspend fun forceUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpgrade = mapped
    }

    /**
     * @param value The instance type of the instance. For more information, see [Instance types](https://www.alibabacloud.com/help/en/apsaradb-for-redis/latest/instance-types).
     */
    @JvmName("hgktrkymwxdtiodl")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The storage medium of the instance. Valid values: tair_rdb, tair_scm, tair_essd.
     */
    @JvmName("wvqffjamdfdcqlke")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Node type, value: MASTER_SLAVE: high availability (dual copy) STAND_ALONE: single copy double: double copy single: single copy Note For Cloud Native instances, select MASTER_SLAVE or STAND_ALONE. For Classic instances, select double or single.
     */
    @JvmName("arsqxibisxhpbxca")
    public suspend fun nodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeType = mapped
    }

    /**
     * @param value The password that is used to connect to the instance. The password must be 8 to 32 characters in length and contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include ! @ # $ % ^ & * ( ) _ + - =
     */
    @JvmName("jdcqldyamrqroxsx")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Payment type: Subscription (prepaid), PayAsYouGo (postpaid). Default PayAsYouGo. Since version 1.227.0, you can transfer prepaid instance to postpaid.
     */
    @JvmName("oobnrbkamoyafqmq")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The subscription duration. Unit: months. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24,36, and 60. This parameter is required only if you set the PaymentType parameter to Subscription.
     */
    @JvmName("opkgctrxlacbabew")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The Tair service port. The service port of the instance. Valid values: 1024 to 65535. Default value: 6379.
     */
    @JvmName("mxmypvwwvvjuwtbq")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Number of read-only nodes in the primary zone. Valid values: 0 to 5. This parameter is only applicable to the following conditions: If the instance is in the cloud disk version standard architecture, you can set this parameter to a value greater than 0 to enable the read/write splitting architecture. If the instance is a cloud disk version read/write splitting architecture instance, you can use this parameter to customize the number of read-only nodes, or set this parameter to 0 to disable the read/write splitting architecture and switch the instance to the standard architecture.
     */
    @JvmName("pgfrywjcuamgdlfq")
    public suspend fun readOnlyCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyCount = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("alnwvykhmsvcqsvb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the secondary zone.This parameter is returned only if the instance is deployed in two zones.
     */
    @JvmName("msfvyxdtoelbldtl")
    public suspend fun secondaryZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryZoneId = mapped
    }

    /**
     * @param value Security group ID
     */
    @JvmName("lhiptftrdcgylsox")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The number of data nodes in the instance. When 1 is passed, it means that the instance created is a standard architecture with only one data node. You can create an instance in the standard architecture that contains only a single data node. 2 to 32: You can create an instance in the cluster architecture that contains the specified number of data nodes. Only persistent memory-optimized instances can use the cluster architecture. Therefore, you can set this parameter to an integer from 2 to 32 only if you set the InstanceType parameter to tair_scm. It is not allowed to modify the number of shards by modifying this parameter after creating a master-slave architecture instance with or without passing 1.
     */
    @JvmName("udpnhqvpvlbprcsq")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    /**
     * @param value Specifies the number of read-only nodes in the secondary zone when creating a multi-zone read/write splitting instance. Note: To create a multi-zone read/write splitting instance, slaveadonlycount and SecondaryZoneId must be specified at the same time.
     */
    @JvmName("dqwwdxqkdyttcada")
    public suspend fun slaveReadOnlyCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slaveReadOnlyCount = mapped
    }

    /**
     * @param value Modify the TLS(SSL) setting. Value: Expand Details Example values: Enable Enumeration value: Disable Enable Update Reference value Source: DescribeInstanceSSL
     */
    @JvmName("rivvcgkjugjuxbwq")
    public suspend fun sslEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnabled = mapped
    }

    /**
     * @param value The storage type. The value is set to essd_pl1. Note This parameter is only available when the value of InstanceType is tair_essd.
     */
    @JvmName("fwghwahagadryoss")
    public suspend fun storagePerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storagePerformanceLevel = mapped
    }

    /**
     * @param value The value range of different specifications is different, see [ESSD-based instances](https://www.alibabacloud.com/help/en/tair/product-overview/essd-based-instances). When the value of instance_type is "tair_essd", this attribute takes effect and is required.
     */
    @JvmName("jhvdyvmgnrqhvhju")
    public suspend fun storageSizeGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSizeGb = mapped
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("oobtxnljvrbtbubq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource
     */
    @JvmName("htwuvlvyumkdtnao")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("bxaeenkywobiehxj")
    public suspend fun tairInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tairInstanceName = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC).
     */
    @JvmName("jmgdvopshlbsjyyv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the vSwitch to which the instance is connected.
     */
    @JvmName("jpsacqiweaqgatkf")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value Zone ID
     */
    @JvmName("btjkmlenmnjobfth")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): TairInstanceArgs = TairInstanceArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        clusterBackupId = clusterBackupId,
        effectiveTime = effectiveTime,
        engineVersion = engineVersion,
        forceUpgrade = forceUpgrade,
        instanceClass = instanceClass,
        instanceType = instanceType,
        nodeType = nodeType,
        password = password,
        paymentType = paymentType,
        period = period,
        port = port,
        readOnlyCount = readOnlyCount,
        resourceGroupId = resourceGroupId,
        secondaryZoneId = secondaryZoneId,
        securityGroupId = securityGroupId,
        shardCount = shardCount,
        slaveReadOnlyCount = slaveReadOnlyCount,
        sslEnabled = sslEnabled,
        storagePerformanceLevel = storagePerformanceLevel,
        storageSizeGb = storageSizeGb,
        tags = tags,
        tairInstanceName = tairInstanceName,
        vpcId = vpcId,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
