@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource = com.pulumi.alicloud.resourcemanager.Account(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Account(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Account resource. Member accounts are containers for resources in a resource directory. These accounts isolate resources and serve as organizational units in the resource directory. You can create member accounts in a folder and then manage them in a unified manner.
 * For information about Resource Manager Account and how to use it, see [What is Resource Manager Account](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).
 * > **NOTE:** Available since v1.83.0.
 * > **NOTE:** From version 1.188.0, the resource can be destroyed. The member deletion feature is in invitational preview. You can contact the service manager of Alibaba Cloud to apply for a trial. see [how to destroy it](https://www.alibabacloud.com/help/en/resource-management/latest/delete-account).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const displayName = config.get("displayName") || "EAccount";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.resourcemanager.getFolders({});
 * const exampleAccount = new alicloud.resourcemanager.Account("example", {
 *     displayName: `${displayName}-${_default.result}`,
 *     folderId: example.then(example => example.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * display_name = config.get("displayName")
 * if display_name is None:
 *     display_name = "EAccount"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.resourcemanager.get_folders()
 * example_account = alicloud.resourcemanager.Account("example",
 *     display_name=f"{display_name}-{default['result']}",
 *     folder_id=example.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var displayName = config.Get("displayName") ?? "EAccount";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.ResourceManager.GetFolders.Invoke();
 *     var exampleAccount = new AliCloud.ResourceManager.Account("example", new()
 *     {
 *         DisplayName = $"{displayName}-{@default.Result}",
 *         FolderId = example.Apply(getFoldersResult => getFoldersResult.Ids[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		displayName := "EAccount"
 * 		if param := cfg.Get("displayName"); param != "" {
 * 			displayName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := resourcemanager.GetFolders(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewAccount(ctx, "example", &resourcemanager.AccountArgs{
 * 			DisplayName: pulumi.Sprintf("%v-%v", displayName, _default.Result),
 * 			FolderId:    pulumi.String(example.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetFoldersArgs;
 * import com.pulumi.alicloud.resourcemanager.Account;
 * import com.pulumi.alicloud.resourcemanager.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var displayName = config.get("displayName").orElse("EAccount");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = ResourcemanagerFunctions.getFolders();
 *         var exampleAccount = new Account("exampleAccount", AccountArgs.builder()
 *             .displayName(String.format("%s-%s", displayName,default_.result()))
 *             .folderId(example.applyValue(getFoldersResult -> getFoldersResult.ids()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   displayName:
 *     type: string
 *     default: EAccount
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleAccount:
 *     type: alicloud:resourcemanager:Account
 *     name: example
 *     properties:
 *       displayName: ${displayName}-${default.result}
 *       folderId: ${example.ids[0]}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getFolders
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Deleting `alicloud.resourcemanager.Account` or removing it from your configuration
 * Deleting the resource manager account or removing it from your configuration will remove it from your state file and management,
 * but may not destroy the account. If there are some dependent resource in the account,
 * the deleting account will enter a silence period of 45 days. After the silence period ends,
 * the system automatically starts to delete the member. [See More Details](https://www.alibabacloud.com/help/en/resource-management/latest/delete-resource-account).
 * ## Import
 * Resource Manager Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/account:Account example 13148890145*****
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * The IDs of the check items that you can choose to ignore for the member deletion.
     * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
     * to get check ids and set them.
     */
    public val abandonAbleCheckIds: Output<List<String>>?
        get() = javaResource.abandonAbleCheckIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name prefix of account.
     */
    public val accountNamePrefix: Output<String>?
        get() = javaResource.accountNamePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Member name. The length is 2 ~ 50 characters or Chinese characters, which can include Chinese characters, English letters, numbers, underscores (_), dots (.) And dashes (-).
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The ID of the parent folder.
     */
    public val folderId: Output<String>
        get() = javaResource.folderId().applyValue({ args0 -> args0 })

    /**
     * Ways for members to join the resource directory. Valid values: `invited`, `created`.
     */
    public val joinMethod: Output<String>
        get() = javaResource.joinMethod().applyValue({ args0 -> args0 })

    /**
     * The time when the member joined the resource directory.
     */
    public val joinTime: Output<String>
        get() = javaResource.joinTime().applyValue({ args0 -> args0 })

    /**
     * The modification time of the invitation.
     */
    public val modifyTime: Output<String>
        get() = javaResource.modifyTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    public val payerAccountId: Output<String>?
        get() = javaResource.payerAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource directory ID.
     */
    public val resourceDirectoryId: Output<String>
        get() = javaResource.resourceDirectoryId().applyValue({ args0 -> args0 })

    /**
     * Member joining status. Valid values: `CreateSuccess`,`CreateVerifying`,`CreateFailed`,`CreateExpired`,`CreateCancelled`,`PromoteVerifying`,`PromoteFailed`,`PromoteExpired`,`PromoteCancelled`,`PromoteSuccess`,`InviteSuccess`,`Removed`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * > **NOTE:** The member name must be unique within the resource directory.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Member type. The value of `ResourceAccount` indicates the resource account.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.alicloud.resourcemanager.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
