@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Account resource. Member accounts are containers for resources in a resource directory. These accounts isolate resources and serve as organizational units in the resource directory. You can create member accounts in a folder and then manage them in a unified manner.
 * For information about Resource Manager Account and how to use it, see [What is Resource Manager Account](https://www.alibabacloud.com/help/en/doc-detail/111231.htm).
 * > **NOTE:** Available since v1.83.0.
 * > **NOTE:** From version 1.188.0, the resource can be destroyed. The member deletion feature is in invitational preview. You can contact the service manager of Alibaba Cloud to apply for a trial. see [how to destroy it](https://www.alibabacloud.com/help/en/resource-management/latest/delete-account).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const displayName = config.get("displayName") || "EAccount";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.resourcemanager.getFolders({});
 * const exampleAccount = new alicloud.resourcemanager.Account("example", {
 *     displayName: `${displayName}-${_default.result}`,
 *     folderId: example.then(example => example.ids?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * display_name = config.get("displayName")
 * if display_name is None:
 *     display_name = "EAccount"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.resourcemanager.get_folders()
 * example_account = alicloud.resourcemanager.Account("example",
 *     display_name=f"{display_name}-{default['result']}",
 *     folder_id=example.ids[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var displayName = config.Get("displayName") ?? "EAccount";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.ResourceManager.GetFolders.Invoke();
 *     var exampleAccount = new AliCloud.ResourceManager.Account("example", new()
 *     {
 *         DisplayName = $"{displayName}-{@default.Result}",
 *         FolderId = example.Apply(getFoldersResult => getFoldersResult.Ids[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		displayName := "EAccount"
 * 		if param := cfg.Get("displayName"); param != "" {
 * 			displayName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := resourcemanager.GetFolders(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewAccount(ctx, "example", &resourcemanager.AccountArgs{
 * 			DisplayName: pulumi.Sprintf("%v-%v", displayName, _default.Result),
 * 			FolderId:    pulumi.String(example.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetFoldersArgs;
 * import com.pulumi.alicloud.resourcemanager.Account;
 * import com.pulumi.alicloud.resourcemanager.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var displayName = config.get("displayName").orElse("EAccount");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = ResourcemanagerFunctions.getFolders();
 *         var exampleAccount = new Account("exampleAccount", AccountArgs.builder()
 *             .displayName(String.format("%s-%s", displayName,default_.result()))
 *             .folderId(example.applyValue(getFoldersResult -> getFoldersResult.ids()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   displayName:
 *     type: string
 *     default: EAccount
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleAccount:
 *     type: alicloud:resourcemanager:Account
 *     name: example
 *     properties:
 *       displayName: ${displayName}-${default.result}
 *       folderId: ${example.ids[0]}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getFolders
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Deleting `alicloud.resourcemanager.Account` or removing it from your configuration
 * Deleting the resource manager account or removing it from your configuration will remove it from your state file and management,
 * but may not destroy the account. If there are some dependent resource in the account,
 * the deleting account will enter a silence period of 45 days. After the silence period ends,
 * the system automatically starts to delete the member. [See More Details](https://www.alibabacloud.com/help/en/resource-management/latest/delete-resource-account).
 * ## Import
 * Resource Manager Account can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/account:Account example 13148890145*****
 * ```
 * @property abandonAbleCheckIds The IDs of the check items that you can choose to ignore for the member deletion.
 * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
 * to get check ids and set them.
 * @property accountNamePrefix The name prefix of account.
 * @property displayName Member name. The length is 2 ~ 50 characters or Chinese characters, which can include Chinese characters, English letters, numbers, underscores (_), dots (.) And dashes (-).
 * @property folderId The ID of the parent folder.
 * @property payerAccountId The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
 * @property tags A mapping of tags to assign to the resource.
 * > **NOTE:** The member name must be unique within the resource directory.
 */
public data class AccountArgs(
    public val abandonAbleCheckIds: Output<List<String>>? = null,
    public val accountNamePrefix: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val folderId: Output<String>? = null,
    public val payerAccountId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.AccountArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.AccountArgs =
        com.pulumi.alicloud.resourcemanager.AccountArgs.builder()
            .abandonAbleCheckIds(abandonAbleCheckIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .accountNamePrefix(accountNamePrefix?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .folderId(folderId?.applyValue({ args0 -> args0 }))
            .payerAccountId(payerAccountId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var abandonAbleCheckIds: Output<List<String>>? = null

    private var accountNamePrefix: Output<String>? = null

    private var displayName: Output<String>? = null

    private var folderId: Output<String>? = null

    private var payerAccountId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The IDs of the check items that you can choose to ignore for the member deletion.
     * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
     * to get check ids and set them.
     */
    @JvmName("nckybmpveljwssto")
    public suspend fun abandonAbleCheckIds(`value`: Output<List<String>>) {
        this.abandonAbleCheckIds = value
    }

    @JvmName("kmiyqekaspbegohe")
    public suspend fun abandonAbleCheckIds(vararg values: Output<String>) {
        this.abandonAbleCheckIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the check items that you can choose to ignore for the member deletion.
     * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
     * to get check ids and set them.
     */
    @JvmName("sybeecjggfiytyxk")
    public suspend fun abandonAbleCheckIds(values: List<Output<String>>) {
        this.abandonAbleCheckIds = Output.all(values)
    }

    /**
     * @param value The name prefix of account.
     */
    @JvmName("jmsgplvdxckylmmw")
    public suspend fun accountNamePrefix(`value`: Output<String>) {
        this.accountNamePrefix = value
    }

    /**
     * @param value Member name. The length is 2 ~ 50 characters or Chinese characters, which can include Chinese characters, English letters, numbers, underscores (_), dots (.) And dashes (-).
     */
    @JvmName("qirpwagmgceovrjt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ID of the parent folder.
     */
    @JvmName("gowesxwunemladqt")
    public suspend fun folderId(`value`: Output<String>) {
        this.folderId = value
    }

    /**
     * @param value The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    @JvmName("kvkakaeorekfmukj")
    public suspend fun payerAccountId(`value`: Output<String>) {
        this.payerAccountId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * > **NOTE:** The member name must be unique within the resource directory.
     */
    @JvmName("fisokdabkodspcfo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IDs of the check items that you can choose to ignore for the member deletion.
     * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
     * to get check ids and set them.
     */
    @JvmName("wvdcunapekwavsbl")
    public suspend fun abandonAbleCheckIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abandonAbleCheckIds = mapped
    }

    /**
     * @param values The IDs of the check items that you can choose to ignore for the member deletion.
     * If you want to delete the account, please use datasource `alicloud.resourcemanager.getAccountDeletionCheckTask`
     * to get check ids and set them.
     */
    @JvmName("jixkpdkwghffelyi")
    public suspend fun abandonAbleCheckIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.abandonAbleCheckIds = mapped
    }

    /**
     * @param value The name prefix of account.
     */
    @JvmName("cvdlufncumqfiywt")
    public suspend fun accountNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountNamePrefix = mapped
    }

    /**
     * @param value Member name. The length is 2 ~ 50 characters or Chinese characters, which can include Chinese characters, English letters, numbers, underscores (_), dots (.) And dashes (-).
     */
    @JvmName("gkjavhpwikcknloy")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ID of the parent folder.
     */
    @JvmName("tbdbcfkseexilicj")
    public suspend fun folderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderId = mapped
    }

    /**
     * @param value The ID of the billing account. If you leave this parameter empty, the current account is used as the billing account.
     */
    @JvmName("cunplnsbrggavkem")
    public suspend fun payerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payerAccountId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * > **NOTE:** The member name must be unique within the resource directory.
     */
    @JvmName("srlqghierdsxwtwh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * > **NOTE:** The member name must be unique within the resource directory.
     */
    @JvmName("jeohhglccpttobiw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        abandonAbleCheckIds = abandonAbleCheckIds,
        accountNamePrefix = accountNamePrefix,
        displayName = displayName,
        folderId = folderId,
        payerAccountId = payerAccountId,
        tags = tags,
    )
}
