@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ControlPolicy].
 */
@PulumiTagMarker
public class ControlPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlPolicyArgs = ControlPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlPolicyArgsBuilder.() -> Unit) {
        val builder = ControlPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ControlPolicy {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.ControlPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ControlPolicy(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Control Policy resource.
 * For information about Resource Manager Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcedirectorymaster-2022-04-19-createcontrolpolicy).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.resourcemanager.ControlPolicy("example", {
 *     controlPolicyName: name,
 *     description: name,
 *     effectScope: "RAM",
 *     policyDocument: `  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.resourcemanager.ControlPolicy("example",
 *     control_policy_name=name,
 *     description=name,
 *     effect_scope="RAM",
 *     policy_document="""  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.ResourceManager.ControlPolicy("example", new()
 *     {
 *         ControlPolicyName = name,
 *         Description = name,
 *         EffectScope = "RAM",
 *         PolicyDocument = @"  {
 *     ""Version"": ""1"",
 *     ""Statement"": [
 *       {
 *         ""Effect"": ""Deny"",
 *         ""Action"": [
 *           ""ram:UpdateRole"",
 *           ""ram:DeleteRole"",
 *           ""ram:AttachPolicyToRole"",
 *           ""ram:DetachPolicyFromRole""
 *         ],
 *         ""Resource"": ""acs:ram:*:*:role/ResourceDirectoryAccountAccessRole""
 *       }
 *     ]
 *   }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewControlPolicy(ctx, "example", &resourcemanager.ControlPolicyArgs{
 * 			ControlPolicyName: pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			EffectScope:       pulumi.String("RAM"),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicy;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new ControlPolicy("example", ControlPolicyArgs.builder()
 *             .controlPolicyName(name)
 *             .description(name)
 *             .effectScope("RAM")
 *             .policyDocument("""
 *   {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ControlPolicy
 *     properties:
 *       controlPolicyName: ${name}
 *       description: ${name}
 *       effectScope: RAM
 *       policyDocument: |2
 *           {
 *             "Version": "1",
 *             "Statement": [
 *               {
 *                 "Effect": "Deny",
 *                 "Action": [
 *                   "ram:UpdateRole",
 *                   "ram:DeleteRole",
 *                   "ram:AttachPolicyToRole",
 *                   "ram:DetachPolicyFromRole"
 *                 ],
 *                 "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *               }
 *             ]
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/controlPolicy:ControlPolicy example <id>
 * ```
 */
public class ControlPolicy internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.ControlPolicy,
) : KotlinCustomResource(javaResource, ControlPolicyMapper) {
    /**
     * The name of control policy.
     */
    public val controlPolicyName: Output<String>
        get() = javaResource.controlPolicyName().applyValue({ args0 -> args0 })

    /**
     * The description of control policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The effect scope. Valid values `RAM`.
     */
    public val effectScope: Output<String>
        get() = javaResource.effectScope().applyValue({ args0 -> args0 })

    /**
     * The policy document of control policy.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })
}

public object ControlPolicyMapper : ResourceMapper<ControlPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.ControlPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ControlPolicy = ControlPolicy(
        javaResource as
            com.pulumi.alicloud.resourcemanager.ControlPolicy,
    )
}

/**
 * @see [ControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ControlPolicy].
 */
public suspend fun controlPolicy(
    name: String,
    block: suspend ControlPolicyResourceBuilder.() -> Unit,
): ControlPolicy {
    val builder = ControlPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ControlPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controlPolicy(name: String): ControlPolicy {
    val builder = ControlPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
