@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ControlPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Control Policy resource.
 * For information about Resource Manager Control Policy and how to use it, see [What is Control Policy](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcedirectorymaster-2022-04-19-createcontrolpolicy).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.resourcemanager.ControlPolicy("example", {
 *     controlPolicyName: name,
 *     description: name,
 *     effectScope: "RAM",
 *     policyDocument: `  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.resourcemanager.ControlPolicy("example",
 *     control_policy_name=name,
 *     description=name,
 *     effect_scope="RAM",
 *     policy_document="""  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.ResourceManager.ControlPolicy("example", new()
 *     {
 *         ControlPolicyName = name,
 *         Description = name,
 *         EffectScope = "RAM",
 *         PolicyDocument = @"  {
 *     ""Version"": ""1"",
 *     ""Statement"": [
 *       {
 *         ""Effect"": ""Deny"",
 *         ""Action"": [
 *           ""ram:UpdateRole"",
 *           ""ram:DeleteRole"",
 *           ""ram:AttachPolicyToRole"",
 *           ""ram:DetachPolicyFromRole""
 *         ],
 *         ""Resource"": ""acs:ram:*:*:role/ResourceDirectoryAccountAccessRole""
 *       }
 *     ]
 *   }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewControlPolicy(ctx, "example", &resourcemanager.ControlPolicyArgs{
 * 			ControlPolicyName: pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			EffectScope:       pulumi.String("RAM"),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicy;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new ControlPolicy("example", ControlPolicyArgs.builder()
 *             .controlPolicyName(name)
 *             .description(name)
 *             .effectScope("RAM")
 *             .policyDocument("""
 *   {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ControlPolicy
 *     properties:
 *       controlPolicyName: ${name}
 *       description: ${name}
 *       effectScope: RAM
 *       policyDocument: |2
 *           {
 *             "Version": "1",
 *             "Statement": [
 *               {
 *                 "Effect": "Deny",
 *                 "Action": [
 *                   "ram:UpdateRole",
 *                   "ram:DeleteRole",
 *                   "ram:AttachPolicyToRole",
 *                   "ram:DetachPolicyFromRole"
 *                 ],
 *                 "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *               }
 *             ]
 *           }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Control Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/controlPolicy:ControlPolicy example <id>
 * ```
 * @property controlPolicyName The name of control policy.
 * @property description The description of control policy.
 * @property effectScope The effect scope. Valid values `RAM`.
 * @property policyDocument The policy document of control policy.
 */
public data class ControlPolicyArgs(
    public val controlPolicyName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val effectScope: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ControlPolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ControlPolicyArgs =
        com.pulumi.alicloud.resourcemanager.ControlPolicyArgs.builder()
            .controlPolicyName(controlPolicyName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .effectScope(effectScope?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPolicyArgs].
 */
@PulumiTagMarker
public class ControlPolicyArgsBuilder internal constructor() {
    private var controlPolicyName: Output<String>? = null

    private var description: Output<String>? = null

    private var effectScope: Output<String>? = null

    private var policyDocument: Output<String>? = null

    /**
     * @param value The name of control policy.
     */
    @JvmName("lqwoafeicephvubf")
    public suspend fun controlPolicyName(`value`: Output<String>) {
        this.controlPolicyName = value
    }

    /**
     * @param value The description of control policy.
     */
    @JvmName("cgnmmepqexsjawcp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The effect scope. Valid values `RAM`.
     */
    @JvmName("rueeqboomlfsygie")
    public suspend fun effectScope(`value`: Output<String>) {
        this.effectScope = value
    }

    /**
     * @param value The policy document of control policy.
     */
    @JvmName("xlqinyhvofenmflr")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The name of control policy.
     */
    @JvmName("nkxoioypxdrvtouv")
    public suspend fun controlPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPolicyName = mapped
    }

    /**
     * @param value The description of control policy.
     */
    @JvmName("jhcfucgndmqjyyqm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The effect scope. Valid values `RAM`.
     */
    @JvmName("mmxfidajfvlhulrx")
    public suspend fun effectScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectScope = mapped
    }

    /**
     * @param value The policy document of control policy.
     */
    @JvmName("opyxwjklgthlshdn")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    internal fun build(): ControlPolicyArgs = ControlPolicyArgs(
        controlPolicyName = controlPolicyName,
        description = description,
        effectScope = effectScope,
        policyDocument = policyDocument,
    )
}
