@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ControlPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Control Policy Attachment resource.
 * For information about Resource Manager Control Policy Attachment and how to use it, see [What is Control Policy Attachment](https://www.alibabacloud.com/help/en/resource-management/latest/api-resourcedirectorymaster-2022-04-19-attachcontrolpolicy).
 * > **NOTE:** Available since v1.120.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.resourcemanager.ControlPolicy("example", {
 *     controlPolicyName: name,
 *     description: name,
 *     effectScope: "RAM",
 *     policyDocument: `  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `,
 * });
 * const exampleFolder = new alicloud.resourcemanager.Folder("example", {folderName: `${name}-${_default.result}`});
 * const exampleControlPolicyAttachment = new alicloud.resourcemanager.ControlPolicyAttachment("example", {
 *     policyId: example.id,
 *     targetId: exampleFolder.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.resourcemanager.ControlPolicy("example",
 *     control_policy_name=name,
 *     description=name,
 *     effect_scope="RAM",
 *     policy_document="""  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * """)
 * example_folder = alicloud.resourcemanager.Folder("example", folder_name=f"{name}-{default['result']}")
 * example_control_policy_attachment = alicloud.resourcemanager.ControlPolicyAttachment("example",
 *     policy_id=example.id,
 *     target_id=example_folder.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.ResourceManager.ControlPolicy("example", new()
 *     {
 *         ControlPolicyName = name,
 *         Description = name,
 *         EffectScope = "RAM",
 *         PolicyDocument = @"  {
 *     ""Version"": ""1"",
 *     ""Statement"": [
 *       {
 *         ""Effect"": ""Deny"",
 *         ""Action"": [
 *           ""ram:UpdateRole"",
 *           ""ram:DeleteRole"",
 *           ""ram:AttachPolicyToRole"",
 *           ""ram:DetachPolicyFromRole""
 *         ],
 *         ""Resource"": ""acs:ram:*:*:role/ResourceDirectoryAccountAccessRole""
 *       }
 *     ]
 *   }
 * ",
 *     });
 *     var exampleFolder = new AliCloud.ResourceManager.Folder("example", new()
 *     {
 *         FolderName = $"{name}-{@default.Result}",
 *     });
 *     var exampleControlPolicyAttachment = new AliCloud.ResourceManager.ControlPolicyAttachment("example", new()
 *     {
 *         PolicyId = example.Id,
 *         TargetId = exampleFolder.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := resourcemanager.NewControlPolicy(ctx, "example", &resourcemanager.ControlPolicyArgs{
 * 			ControlPolicyName: pulumi.String(name),
 * 			Description:       pulumi.String(name),
 * 			EffectScope:       pulumi.String("RAM"),
 * 			PolicyDocument: pulumi.String(`  {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleFolder, err := resourcemanager.NewFolder(ctx, "example", &resourcemanager.FolderArgs{
 * 			FolderName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewControlPolicyAttachment(ctx, "example", &resourcemanager.ControlPolicyAttachmentArgs{
 * 			PolicyId: example.ID(),
 * 			TargetId: exampleFolder.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicy;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicyArgs;
 * import com.pulumi.alicloud.resourcemanager.Folder;
 * import com.pulumi.alicloud.resourcemanager.FolderArgs;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicyAttachment;
 * import com.pulumi.alicloud.resourcemanager.ControlPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new ControlPolicy("example", ControlPolicyArgs.builder()
 *             .controlPolicyName(name)
 *             .description(name)
 *             .effectScope("RAM")
 *             .policyDocument("""
 *   {
 *     "Version": "1",
 *     "Statement": [
 *       {
 *         "Effect": "Deny",
 *         "Action": [
 *           "ram:UpdateRole",
 *           "ram:DeleteRole",
 *           "ram:AttachPolicyToRole",
 *           "ram:DetachPolicyFromRole"
 *         ],
 *         "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *       }
 *     ]
 *   }
 *             """)
 *             .build());
 *         var exampleFolder = new Folder("exampleFolder", FolderArgs.builder()
 *             .folderName(String.format("%s-%s", name,default_.result()))
 *             .build());
 *         var exampleControlPolicyAttachment = new ControlPolicyAttachment("exampleControlPolicyAttachment", ControlPolicyAttachmentArgs.builder()
 *             .policyId(example.id())
 *             .targetId(exampleFolder.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:resourcemanager:ControlPolicy
 *     properties:
 *       controlPolicyName: ${name}
 *       description: ${name}
 *       effectScope: RAM
 *       policyDocument: |2
 *           {
 *             "Version": "1",
 *             "Statement": [
 *               {
 *                 "Effect": "Deny",
 *                 "Action": [
 *                   "ram:UpdateRole",
 *                   "ram:DeleteRole",
 *                   "ram:AttachPolicyToRole",
 *                   "ram:DetachPolicyFromRole"
 *                 ],
 *                 "Resource": "acs:ram:*:*:role/ResourceDirectoryAccountAccessRole"
 *               }
 *             ]
 *           }
 *   exampleFolder:
 *     type: alicloud:resourcemanager:Folder
 *     name: example
 *     properties:
 *       folderName: ${name}-${default.result}
 *   exampleControlPolicyAttachment:
 *     type: alicloud:resourcemanager:ControlPolicyAttachment
 *     name: example
 *     properties:
 *       policyId: ${example.id}
 *       targetId: ${exampleFolder.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Control Policy Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/controlPolicyAttachment:ControlPolicyAttachment example <policy_id>:<target_id>
 * ```
 * @property policyId The ID of control policy.
 * @property targetId The ID of target.
 */
public data class ControlPolicyAttachmentArgs(
    public val policyId: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ControlPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ControlPolicyAttachmentArgs =
        com.pulumi.alicloud.resourcemanager.ControlPolicyAttachmentArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class ControlPolicyAttachmentArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value The ID of control policy.
     */
    @JvmName("aughasisaatnvjyp")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The ID of target.
     */
    @JvmName("mrceuowntvoxefva")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The ID of control policy.
     */
    @JvmName("qofbwebyrwycsnsn")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The ID of target.
     */
    @JvmName("txmyhalpnubsgexi")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): ControlPolicyAttachmentArgs = ControlPolicyAttachmentArgs(
        policyId = policyId,
        targetId = targetId,
    )
}
