@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.DelegatedAdministratorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Delegated Administrator resource.
 * For information about Resource Manager Delegated Administrator and how to use it, see [What is Delegated Administrator](https://www.alibabacloud.com/help/en/resource-management/latest/registerdelegatedadministrator#doc-api-ResourceManager-RegisterDelegatedAdministrator).
 * > **NOTE:** Available since v1.181.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const displayName = config.get("displayName") || "EAccount";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = alicloud.resourcemanager.getFolders({});
 * const exampleAccount = new alicloud.resourcemanager.Account("example", {
 *     displayName: `${displayName}-${_default.result}`,
 *     folderId: example.then(example => example.ids?.[0]),
 * });
 * const exampleDelegatedAdministrator = new alicloud.resourcemanager.DelegatedAdministrator("example", {
 *     accountId: exampleAccount.id,
 *     servicePrincipal: "cloudfw.aliyuncs.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * display_name = config.get("displayName")
 * if display_name is None:
 *     display_name = "EAccount"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.resourcemanager.get_folders()
 * example_account = alicloud.resourcemanager.Account("example",
 *     display_name=f"{display_name}-{default['result']}",
 *     folder_id=example.ids[0])
 * example_delegated_administrator = alicloud.resourcemanager.DelegatedAdministrator("example",
 *     account_id=example_account.id,
 *     service_principal="cloudfw.aliyuncs.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var displayName = config.Get("displayName") ?? "EAccount";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = AliCloud.ResourceManager.GetFolders.Invoke();
 *     var exampleAccount = new AliCloud.ResourceManager.Account("example", new()
 *     {
 *         DisplayName = $"{displayName}-{@default.Result}",
 *         FolderId = example.Apply(getFoldersResult => getFoldersResult.Ids[0]),
 *     });
 *     var exampleDelegatedAdministrator = new AliCloud.ResourceManager.DelegatedAdministrator("example", new()
 *     {
 *         AccountId = exampleAccount.Id,
 *         ServicePrincipal = "cloudfw.aliyuncs.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		displayName := "EAccount"
 * 		if param := cfg.Get("displayName"); param != "" {
 * 			displayName = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := resourcemanager.GetFolders(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleAccount, err := resourcemanager.NewAccount(ctx, "example", &resourcemanager.AccountArgs{
 * 			DisplayName: pulumi.Sprintf("%v-%v", displayName, _default.Result),
 * 			FolderId:    pulumi.String(example.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewDelegatedAdministrator(ctx, "example", &resourcemanager.DelegatedAdministratorArgs{
 * 			AccountId:        exampleAccount.ID(),
 * 			ServicePrincipal: pulumi.String("cloudfw.aliyuncs.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetFoldersArgs;
 * import com.pulumi.alicloud.resourcemanager.Account;
 * import com.pulumi.alicloud.resourcemanager.AccountArgs;
 * import com.pulumi.alicloud.resourcemanager.DelegatedAdministrator;
 * import com.pulumi.alicloud.resourcemanager.DelegatedAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var displayName = config.get("displayName").orElse("EAccount");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var example = ResourcemanagerFunctions.getFolders();
 *         var exampleAccount = new Account("exampleAccount", AccountArgs.builder()
 *             .displayName(String.format("%s-%s", displayName,default_.result()))
 *             .folderId(example.applyValue(getFoldersResult -> getFoldersResult.ids()[0]))
 *             .build());
 *         var exampleDelegatedAdministrator = new DelegatedAdministrator("exampleDelegatedAdministrator", DelegatedAdministratorArgs.builder()
 *             .accountId(exampleAccount.id())
 *             .servicePrincipal("cloudfw.aliyuncs.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 *   displayName:
 *     type: string
 *     default: EAccount
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   exampleAccount:
 *     type: alicloud:resourcemanager:Account
 *     name: example
 *     properties:
 *       displayName: ${displayName}-${default.result}
 *       folderId: ${example.ids[0]}
 *   exampleDelegatedAdministrator:
 *     type: alicloud:resourcemanager:DelegatedAdministrator
 *     name: example
 *     properties:
 *       accountId: ${exampleAccount.id}
 *       servicePrincipal: cloudfw.aliyuncs.com
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getFolders
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Delegated Administrator can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/delegatedAdministrator:DelegatedAdministrator example <account_id>:<service_principal>
 * ```
 * @property accountId The ID of the member account in the resource directory.
 * @property servicePrincipal The identification of the trusted service. **NOTE:** Only some trusted services support delegated administrator accounts. For more information, see [Supported trusted services](https://www.alibabacloud.com/help/en/resource-management/latest/manage-trusted-services-overview).
 */
public data class DelegatedAdministratorArgs(
    public val accountId: Output<String>? = null,
    public val servicePrincipal: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.DelegatedAdministratorArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.DelegatedAdministratorArgs =
        com.pulumi.alicloud.resourcemanager.DelegatedAdministratorArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .servicePrincipal(servicePrincipal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegatedAdministratorArgs].
 */
@PulumiTagMarker
public class DelegatedAdministratorArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var servicePrincipal: Output<String>? = null

    /**
     * @param value The ID of the member account in the resource directory.
     */
    @JvmName("magiyvavpieylrmg")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The identification of the trusted service. **NOTE:** Only some trusted services support delegated administrator accounts. For more information, see [Supported trusted services](https://www.alibabacloud.com/help/en/resource-management/latest/manage-trusted-services-overview).
     */
    @JvmName("oygsvhhyktcjgdpp")
    public suspend fun servicePrincipal(`value`: Output<String>) {
        this.servicePrincipal = value
    }

    /**
     * @param value The ID of the member account in the resource directory.
     */
    @JvmName("fyqvmqohyotnpcpy")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The identification of the trusted service. **NOTE:** Only some trusted services support delegated administrator accounts. For more information, see [Supported trusted services](https://www.alibabacloud.com/help/en/resource-management/latest/manage-trusted-services-overview).
     */
    @JvmName("atptejpvxksiksvp")
    public suspend fun servicePrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipal = mapped
    }

    internal fun build(): DelegatedAdministratorArgs = DelegatedAdministratorArgs(
        accountId = accountId,
        servicePrincipal = servicePrincipal,
    )
}
