@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.FolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Folder resource. A folder is an organizational unit in a resource directory. You can use folders to build an organizational structure for resources.
 * For information about Resource Manager Foler and how to use it, see [What is Resource Manager Folder](https://www.alibabacloud.com/help/en/doc-detail/111221.htm).
 * > **NOTE:** Available since v1.82.0.
 * > **NOTE:** A maximum of five levels of folders can be created under the root folder.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.resourcemanager.Folder("example", {folderName: `${name}-${_default.result}`});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.resourcemanager.Folder("example", folder_name=f"{name}-{default['result']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.ResourceManager.Folder("example", new()
 *     {
 *         FolderName = $"{name}-{@default.Result}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewFolder(ctx, "example", &resourcemanager.FolderArgs{
 * 			FolderName: pulumi.Sprintf("%v-%v", name, _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.resourcemanager.Folder;
 * import com.pulumi.alicloud.resourcemanager.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderName(String.format("%s-%s", name,default_.result()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:resourcemanager:Folder
 *     properties:
 *       folderName: ${name}-${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Folder can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/folder:Folder example fd-u8B321****
 * ```
 * @property folderName The name of the folder. The name must be 1 to 24 characters in length and can contain letters, digits, underscores (_), periods (.), and hyphens (-).
 * @property parentFolderId The ID of the parent folder. If not set, the system default value will be used.
 */
public data class FolderArgs(
    public val folderName: Output<String>? = null,
    public val parentFolderId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.FolderArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.FolderArgs =
        com.pulumi.alicloud.resourcemanager.FolderArgs.builder()
            .folderName(folderName?.applyValue({ args0 -> args0 }))
            .parentFolderId(parentFolderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FolderArgs].
 */
@PulumiTagMarker
public class FolderArgsBuilder internal constructor() {
    private var folderName: Output<String>? = null

    private var parentFolderId: Output<String>? = null

    /**
     * @param value The name of the folder. The name must be 1 to 24 characters in length and can contain letters, digits, underscores (_), periods (.), and hyphens (-).
     */
    @JvmName("cirmcpfjwytgqdiw")
    public suspend fun folderName(`value`: Output<String>) {
        this.folderName = value
    }

    /**
     * @param value The ID of the parent folder. If not set, the system default value will be used.
     */
    @JvmName("qgfvebrpgqtvpkmg")
    public suspend fun parentFolderId(`value`: Output<String>) {
        this.parentFolderId = value
    }

    /**
     * @param value The name of the folder. The name must be 1 to 24 characters in length and can contain letters, digits, underscores (_), periods (.), and hyphens (-).
     */
    @JvmName("ixqhsbbbilraupcd")
    public suspend fun folderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderName = mapped
    }

    /**
     * @param value The ID of the parent folder. If not set, the system default value will be used.
     */
    @JvmName("sdebhhxkccsovrwm")
    public suspend fun parentFolderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentFolderId = mapped
    }

    internal fun build(): FolderArgs = FolderArgs(
        folderName = folderName,
        parentFolderId = parentFolderId,
    )
}
