@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Handshake].
 */
@PulumiTagMarker
public class HandshakeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HandshakeArgs = HandshakeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HandshakeArgsBuilder.() -> Unit) {
        val builder = HandshakeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Handshake {
        val builtJavaResource = com.pulumi.alicloud.resourcemanager.Handshake(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Handshake(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager handshake resource. You can invite accounts to join a resource directory for unified management.
 * For information about Resource Manager handshake and how to use it, see [What is Resource Manager handshake](https://www.alibabacloud.com/help/en/doc-detail/135287.htm).
 * > **NOTE:** Available in v1.82.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a Resource Manager handshake.
 * const example = new alicloud.resourcemanager.Handshake("example", {
 *     targetEntity: "1182775234******",
 *     targetType: "Account",
 *     note: "test resource manager handshake",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a Resource Manager handshake.
 * example = alicloud.resourcemanager.Handshake("example",
 *     target_entity="1182775234******",
 *     target_type="Account",
 *     note="test resource manager handshake")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a Resource Manager handshake.
 *     var example = new AliCloud.ResourceManager.Handshake("example", new()
 *     {
 *         TargetEntity = "1182775234******",
 *         TargetType = "Account",
 *         Note = "test resource manager handshake",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a Resource Manager handshake.
 * 		_, err := resourcemanager.NewHandshake(ctx, "example", &resourcemanager.HandshakeArgs{
 * 			TargetEntity: pulumi.String("1182775234******"),
 * 			TargetType:   pulumi.String("Account"),
 * 			Note:         pulumi.String("test resource manager handshake"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Handshake;
 * import com.pulumi.alicloud.resourcemanager.HandshakeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a Resource Manager handshake.
 *         var example = new Handshake("example", HandshakeArgs.builder()
 *             .targetEntity("1182775234******")
 *             .targetType("Account")
 *             .note("test resource manager handshake")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a Resource Manager handshake.
 *   example:
 *     type: alicloud:resourcemanager:Handshake
 *     properties:
 *       targetEntity: 1182775234******
 *       targetType: Account
 *       note: test resource manager handshake
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager handshake can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/handshake:Handshake example h-QmdexeFm1kE*****
 * ```
 */
public class Handshake internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.Handshake,
) : KotlinCustomResource(javaResource, HandshakeMapper) {
    /**
     * The expiration time of the invitation.
     */
    public val expireTime: Output<String>
        get() = javaResource.expireTime().applyValue({ args0 -> args0 })

    /**
     * Resource account master account ID.
     */
    public val masterAccountId: Output<String>
        get() = javaResource.masterAccountId().applyValue({ args0 -> args0 })

    /**
     * The name of the main account of the resource directory.
     */
    public val masterAccountName: Output<String>
        get() = javaResource.masterAccountName().applyValue({ args0 -> args0 })

    /**
     * The modification time of the invitation.
     */
    public val modifyTime: Output<String>
        get() = javaResource.modifyTime().applyValue({ args0 -> args0 })

    /**
     * Remarks. The maximum length is 1024 characters.
     */
    public val note: Output<String>?
        get() = javaResource.note().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource directory ID.
     */
    public val resourceDirectoryId: Output<String>
        get() = javaResource.resourceDirectoryId().applyValue({ args0 -> args0 })

    /**
     * Invitation status. Valid values: `Pending` waiting for confirmation, `Accepted`, `Cancelled`, `Declined`, `Expired`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Invited account ID or login email.
     */
    public val targetEntity: Output<String>
        get() = javaResource.targetEntity().applyValue({ args0 -> args0 })

    /**
     * Type of account being invited. Valid values: `Account`, `Email`.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })
}

public object HandshakeMapper : ResourceMapper<Handshake> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.Handshake::class == javaResource::class

    override fun map(javaResource: Resource): Handshake = Handshake(
        javaResource as
            com.pulumi.alicloud.resourcemanager.Handshake,
    )
}

/**
 * @see [Handshake].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Handshake].
 */
public suspend fun handshake(name: String, block: suspend HandshakeResourceBuilder.() -> Unit): Handshake {
    val builder = HandshakeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Handshake].
 * @param name The _unique_ name of the resulting resource.
 */
public fun handshake(name: String): Handshake {
    val builder = HandshakeResourceBuilder()
    builder.name(name)
    return builder.build()
}
