@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.HandshakeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager handshake resource. You can invite accounts to join a resource directory for unified management.
 * For information about Resource Manager handshake and how to use it, see [What is Resource Manager handshake](https://www.alibabacloud.com/help/en/doc-detail/135287.htm).
 * > **NOTE:** Available in v1.82.0+.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a Resource Manager handshake.
 * const example = new alicloud.resourcemanager.Handshake("example", {
 *     targetEntity: "1182775234******",
 *     targetType: "Account",
 *     note: "test resource manager handshake",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a Resource Manager handshake.
 * example = alicloud.resourcemanager.Handshake("example",
 *     target_entity="1182775234******",
 *     target_type="Account",
 *     note="test resource manager handshake")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a Resource Manager handshake.
 *     var example = new AliCloud.ResourceManager.Handshake("example", new()
 *     {
 *         TargetEntity = "1182775234******",
 *         TargetType = "Account",
 *         Note = "test resource manager handshake",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a Resource Manager handshake.
 * 		_, err := resourcemanager.NewHandshake(ctx, "example", &resourcemanager.HandshakeArgs{
 * 			TargetEntity: pulumi.String("1182775234******"),
 * 			TargetType:   pulumi.String("Account"),
 * 			Note:         pulumi.String("test resource manager handshake"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Handshake;
 * import com.pulumi.alicloud.resourcemanager.HandshakeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a Resource Manager handshake.
 *         var example = new Handshake("example", HandshakeArgs.builder()
 *             .targetEntity("1182775234******")
 *             .targetType("Account")
 *             .note("test resource manager handshake")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a Resource Manager handshake.
 *   example:
 *     type: alicloud:resourcemanager:Handshake
 *     properties:
 *       targetEntity: 1182775234******
 *       targetType: Account
 *       note: test resource manager handshake
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager handshake can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/handshake:Handshake example h-QmdexeFm1kE*****
 * ```
 * @property note Remarks. The maximum length is 1024 characters.
 * @property targetEntity Invited account ID or login email.
 * @property targetType Type of account being invited. Valid values: `Account`, `Email`.
 */
public data class HandshakeArgs(
    public val note: Output<String>? = null,
    public val targetEntity: Output<String>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.HandshakeArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.HandshakeArgs =
        com.pulumi.alicloud.resourcemanager.HandshakeArgs.builder()
            .note(note?.applyValue({ args0 -> args0 }))
            .targetEntity(targetEntity?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HandshakeArgs].
 */
@PulumiTagMarker
public class HandshakeArgsBuilder internal constructor() {
    private var note: Output<String>? = null

    private var targetEntity: Output<String>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value Remarks. The maximum length is 1024 characters.
     */
    @JvmName("klshseeqdxhvmojc")
    public suspend fun note(`value`: Output<String>) {
        this.note = value
    }

    /**
     * @param value Invited account ID or login email.
     */
    @JvmName("lgimtrogvmnhhfnl")
    public suspend fun targetEntity(`value`: Output<String>) {
        this.targetEntity = value
    }

    /**
     * @param value Type of account being invited. Valid values: `Account`, `Email`.
     */
    @JvmName("estndrhvcijjqnsf")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Remarks. The maximum length is 1024 characters.
     */
    @JvmName("dytlpjorfdtpwnih")
    public suspend fun note(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.note = mapped
    }

    /**
     * @param value Invited account ID or login email.
     */
    @JvmName("roocnvhqmcflyrhd")
    public suspend fun targetEntity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEntity = mapped
    }

    /**
     * @param value Type of account being invited. Valid values: `Account`, `Email`.
     */
    @JvmName("ehyverivpdnvwuef")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): HandshakeArgs = HandshakeArgs(
        note = note,
        targetEntity = targetEntity,
        targetType = targetType,
    )
}
