@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.alicloud.resourcemanager.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Policy resource.
 * For information about Resource Manager Policy and how to use it, see [What is Resource Manager Policy](https://www.alibabacloud.com/help/en/doc-detail/93732.htm).
 * > **NOTE:** Available since v1.83.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.Policy("example", {
 *     policyName: name,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.Policy("example",
 *     policy_name=name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.Policy("example", new()
 *     {
 *         PolicyName = name,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:*""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewPolicy(ctx, "example", &resourcemanager.PolicyArgs{
 * 			PolicyName: pulumi.String(name),
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Policy;
 * import com.pulumi.alicloud.resourcemanager.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyName(name)
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Policy
 *     properties:
 *       policyName: ${name}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:*"]
 *         			}],
 *         			"Version": "1"
 *         		}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policy:Policy example abc12345
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * The version of the policy. Default to v1.
     */
    @Deprecated(
        message = """
  Field 'default_version' has been deprecated from provider version 1.90.0
  """,
    )
    public val defaultVersion: Output<String>
        get() = javaResource.defaultVersion().applyValue({ args0 -> args0 })

    /**
     * The description of the policy. The description must be 1 to 1,024 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * The type of the policy. Valid values: `Custom`, `System`.
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.alicloud.resourcemanager.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
