@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Policy resource.
 * For information about Resource Manager Policy and how to use it, see [What is Resource Manager Policy](https://www.alibabacloud.com/help/en/doc-detail/93732.htm).
 * > **NOTE:** Available since v1.83.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.Policy("example", {
 *     policyName: name,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.Policy("example",
 *     policy_name=name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.Policy("example", new()
 *     {
 *         PolicyName = name,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:*""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewPolicy(ctx, "example", &resourcemanager.PolicyArgs{
 * 			PolicyName: pulumi.String(name),
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Policy;
 * import com.pulumi.alicloud.resourcemanager.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyName(name)
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Policy
 *     properties:
 *       policyName: ${name}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:*"]
 *         			}],
 *         			"Version": "1"
 *         		}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policy:Policy example abc12345
 * ```
 * @property defaultVersion The version of the policy. Default to v1.
 * @property description The description of the policy. The description must be 1 to 1,024 characters in length.
 * @property policyDocument The content of the policy. The content must be 1 to 2,048 characters in length.
 * @property policyName The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
 */
public data class PolicyArgs(
    @Deprecated(
        message = """
  Field 'default_version' has been deprecated from provider version 1.90.0
  """,
    )
    public val defaultVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.PolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.PolicyArgs =
        com.pulumi.alicloud.resourcemanager.PolicyArgs.builder()
            .defaultVersion(defaultVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var defaultVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value The version of the policy. Default to v1.
     */
    @Deprecated(
        message = """
  Field 'default_version' has been deprecated from provider version 1.90.0
  """,
    )
    @JvmName("byrwjvgbdcptwxrx")
    public suspend fun defaultVersion(`value`: Output<String>) {
        this.defaultVersion = value
    }

    /**
     * @param value The description of the policy. The description must be 1 to 1,024 characters in length.
     */
    @JvmName("mtvkpbpkxnwymlps")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    @JvmName("ahjafoohwwdhgyah")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("uiysptujkkuebvfv")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The version of the policy. Default to v1.
     */
    @Deprecated(
        message = """
  Field 'default_version' has been deprecated from provider version 1.90.0
  """,
    )
    @JvmName("tsimgdexyymfupdx")
    public suspend fun defaultVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVersion = mapped
    }

    /**
     * @param value The description of the policy. The description must be 1 to 1,024 characters in length.
     */
    @JvmName("nasjlhlkacvumwgc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    @JvmName("lvnkriutlbdprdqd")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("snehgecqudsvpkug")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        defaultVersion = defaultVersion,
        description = description,
        policyDocument = policyDocument,
        policyName = policyName,
    )
}
