@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyAttachment].
 */
@PulumiTagMarker
public class PolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAttachmentArgs = PolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = PolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.PolicyAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Policy Attachment resource to attaches a policy to an object. After you attach a policy to an object, the object has the operation permissions on the current resource group or the resources under the current account.
 * For information about Resource Manager Policy Attachment and how to use it, see [How to authorize and manage resource groups](https://www.alibabacloud.com/help/en/doc-detail/94490.htm).
 * > **NOTE:** Available since v1.93.0.
 * ## Import
 * Resource Manager Policy Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policyAttachment:PolicyAttachment example tf-testaccrdpolicy:Custom:tf-testaccrdpolicy@11827252********.onaliyun.com:IMSUser:rg******
 * ```
 */
public class PolicyAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.PolicyAttachment,
) : KotlinCustomResource(javaResource, PolicyAttachmentMapper) {
    /**
     * The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })

    /**
     * The type of the policy. Valid values: `Custom`, `System`.
     */
    public val policyType: Output<String>
        get() = javaResource.policyType().applyValue({ args0 -> args0 })

    /**
     * The name of the object to which you want to attach the policy.
     */
    public val principalName: Output<String>
        get() = javaResource.principalName().applyValue({ args0 -> args0 })

    /**
     * The type of the object to which you want to attach the policy. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })
}

public object PolicyAttachmentMapper : ResourceMapper<PolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.PolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAttachment = PolicyAttachment(
        javaResource as
            com.pulumi.alicloud.resourcemanager.PolicyAttachment,
    )
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAttachment].
 */
public suspend fun policyAttachment(
    name: String,
    block: suspend PolicyAttachmentResourceBuilder.() -> Unit,
): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAttachment(name: String): PolicyAttachment {
    val builder = PolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
