@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.PolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Policy Attachment resource to attaches a policy to an object. After you attach a policy to an object, the object has the operation permissions on the current resource group or the resources under the current account.
 * For information about Resource Manager Policy Attachment and how to use it, see [How to authorize and manage resource groups](https://www.alibabacloud.com/help/en/doc-detail/94490.htm).
 * > **NOTE:** Available since v1.93.0.
 * ## Import
 * Resource Manager Policy Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policyAttachment:PolicyAttachment example tf-testaccrdpolicy:Custom:tf-testaccrdpolicy@11827252********.onaliyun.com:IMSUser:rg******
 * ```
 * @property policyName The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
 * @property policyType The type of the policy. Valid values: `Custom`, `System`.
 * @property principalName The name of the object to which you want to attach the policy.
 * @property principalType The type of the object to which you want to attach the policy. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
 * @property resourceGroupId The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs.
 */
public data class PolicyAttachmentArgs(
    public val policyName: Output<String>? = null,
    public val policyType: Output<String>? = null,
    public val principalName: Output<String>? = null,
    public val principalType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.PolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.PolicyAttachmentArgs =
        com.pulumi.alicloud.resourcemanager.PolicyAttachmentArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyType(policyType?.applyValue({ args0 -> args0 }))
            .principalName(principalName?.applyValue({ args0 -> args0 }))
            .principalType(principalType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAttachmentArgs].
 */
@PulumiTagMarker
public class PolicyAttachmentArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var policyType: Output<String>? = null

    private var principalName: Output<String>? = null

    private var principalType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("qdkdtrgsejddffox")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The type of the policy. Valid values: `Custom`, `System`.
     */
    @JvmName("nsnkvgtrdfogimbt")
    public suspend fun policyType(`value`: Output<String>) {
        this.policyType = value
    }

    /**
     * @param value The name of the object to which you want to attach the policy.
     */
    @JvmName("rnfkxmndjbbdnvob")
    public suspend fun principalName(`value`: Output<String>) {
        this.principalName = value
    }

    /**
     * @param value The type of the object to which you want to attach the policy. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
     */
    @JvmName("imcolcofbakrwtll")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs.
     */
    @JvmName("mxptygdpjwbuncjs")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of the policy. name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("gdgypmgtxplmpjng")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The type of the policy. Valid values: `Custom`, `System`.
     */
    @JvmName("rgalsetqrsfgycjg")
    public suspend fun policyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The name of the object to which you want to attach the policy.
     */
    @JvmName("hmsfmrxiuhbimcby")
    public suspend fun principalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalName = mapped
    }

    /**
     * @param value The type of the object to which you want to attach the policy. Valid values: `IMSUser`: RAM user, `IMSGroup`: RAM user group, `ServiceRole`: RAM role.
     */
    @JvmName("wkfmftsyjclndpjs")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The ID of the resource group or the ID of the Alibaba Cloud account to which the resource group belongs.
     */
    @JvmName("newtpjpjcagnjlfn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    internal fun build(): PolicyAttachmentArgs = PolicyAttachmentArgs(
        policyName = policyName,
        policyType = policyType,
        principalName = principalName,
        principalType = principalType,
        resourceGroupId = resourceGroupId,
    )
}
