@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyVersion].
 */
@PulumiTagMarker
public class PolicyVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyVersionArgs = PolicyVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyVersionArgsBuilder.() -> Unit) {
        val builder = PolicyVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyVersion {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.PolicyVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyVersion(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Policy Version resource.
 * For information about Resource Manager Policy Version and how to use it, see [What is Resource Manager Policy Version](https://www.alibabacloud.com/help/en/doc-detail/116817.htm).
 * > **NOTE:** Available since v1.84.0.
 * > **NOTE:** It is not recommended to use this resource management policy version, it is recommended to directly use the policy resource to manage your policy. Please refer to the link for usage resource_manager_policy.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.Policy("example", {
 *     policyName: name,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * const examplePolicyVersion = new alicloud.resourcemanager.PolicyVersion("example", {
 *     policyName: example.policyName,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:myphotos"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.Policy("example",
 *     policy_name=name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * example_policy_version = alicloud.resourcemanager.PolicyVersion("example",
 *     policy_name=example.policy_name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:myphotos"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.Policy("example", new()
 *     {
 *         PolicyName = name,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:*""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 *     var examplePolicyVersion = new AliCloud.ResourceManager.PolicyVersion("example", new()
 *     {
 *         PolicyName = example.PolicyName,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:myphotos""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := resourcemanager.NewPolicy(ctx, "example", &resourcemanager.PolicyArgs{
 * 			PolicyName: pulumi.String(name),
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewPolicyVersion(ctx, "example", &resourcemanager.PolicyVersionArgs{
 * 			PolicyName: example.PolicyName,
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:myphotos"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Policy;
 * import com.pulumi.alicloud.resourcemanager.PolicyArgs;
 * import com.pulumi.alicloud.resourcemanager.PolicyVersion;
 * import com.pulumi.alicloud.resourcemanager.PolicyVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyName(name)
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *         var examplePolicyVersion = new PolicyVersion("examplePolicyVersion", PolicyVersionArgs.builder()
 *             .policyName(example.policyName())
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:myphotos"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Policy
 *     properties:
 *       policyName: ${name}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:*"]
 *         			}],
 *         			"Version": "1"
 *         		}
 *   examplePolicyVersion:
 *     type: alicloud:resourcemanager:PolicyVersion
 *     name: example
 *     properties:
 *       policyName: ${example.policyName}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:myphotos"]
 *         			}],
 *         			"Version": "1"
 *         		}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Policy Version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policyVersion:PolicyVersion example tftest:v2
 * ```
 */
public class PolicyVersion internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.PolicyVersion,
) : KotlinCustomResource(javaResource, PolicyVersionMapper) {
    /**
     * Specifies whether to set the policy version as the default version. Default to `false`.
     */
    @Deprecated(
        message = """
  Field 'is_default_version' has been deprecated from provider version 1.90.0
  """,
    )
    public val isDefaultVersion: Output<Boolean>?
        get() = javaResource.isDefaultVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    public val policyName: Output<String>
        get() = javaResource.policyName().applyValue({ args0 -> args0 })
}

public object PolicyVersionMapper : ResourceMapper<PolicyVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.PolicyVersion::class == javaResource::class

    override fun map(javaResource: Resource): PolicyVersion = PolicyVersion(
        javaResource as
            com.pulumi.alicloud.resourcemanager.PolicyVersion,
    )
}

/**
 * @see [PolicyVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyVersion].
 */
public suspend fun policyVersion(
    name: String,
    block: suspend PolicyVersionResourceBuilder.() -> Unit,
): PolicyVersion {
    val builder = PolicyVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyVersion(name: String): PolicyVersion {
    val builder = PolicyVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
