@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.PolicyVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Policy Version resource.
 * For information about Resource Manager Policy Version and how to use it, see [What is Resource Manager Policy Version](https://www.alibabacloud.com/help/en/doc-detail/116817.htm).
 * > **NOTE:** Available since v1.84.0.
 * > **NOTE:** It is not recommended to use this resource management policy version, it is recommended to directly use the policy resource to manage your policy. Please refer to the link for usage resource_manager_policy.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.Policy("example", {
 *     policyName: name,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * const examplePolicyVersion = new alicloud.resourcemanager.PolicyVersion("example", {
 *     policyName: example.policyName,
 *     policyDocument: `\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:myphotos"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.Policy("example",
 *     policy_name=name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:*"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * example_policy_version = alicloud.resourcemanager.PolicyVersion("example",
 *     policy_name=example.policy_name,
 *     policy_document="""\x09\x09{
 * \x09\x09\x09"Statement": [{
 * \x09\x09\x09\x09"Action": ["oss:*"],
 * \x09\x09\x09\x09"Effect": "Allow",
 * \x09\x09\x09\x09"Resource": ["acs:oss:*:*:myphotos"]
 * \x09\x09\x09}],
 * \x09\x09\x09"Version": "1"
 * \x09\x09}
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.Policy("example", new()
 *     {
 *         PolicyName = name,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:*""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 *     var examplePolicyVersion = new AliCloud.ResourceManager.PolicyVersion("example", new()
 *     {
 *         PolicyName = example.PolicyName,
 *         PolicyDocument = @"		{
 * 			""Statement"": [{
 * 				""Action"": [""oss:*""],
 * 				""Effect"": ""Allow"",
 * 				""Resource"": [""acs:oss:*:*:myphotos""]
 * 			}],
 * 			""Version"": ""1""
 * 		}
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := resourcemanager.NewPolicy(ctx, "example", &resourcemanager.PolicyArgs{
 * 			PolicyName: pulumi.String(name),
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewPolicyVersion(ctx, "example", &resourcemanager.PolicyVersionArgs{
 * 			PolicyName: example.PolicyName,
 * 			PolicyDocument: pulumi.String(`		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:myphotos"]
 * 			}],
 * 			"Version": "1"
 * 		}
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.Policy;
 * import com.pulumi.alicloud.resourcemanager.PolicyArgs;
 * import com.pulumi.alicloud.resourcemanager.PolicyVersion;
 * import com.pulumi.alicloud.resourcemanager.PolicyVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .policyName(name)
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:*"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *         var examplePolicyVersion = new PolicyVersion("examplePolicyVersion", PolicyVersionArgs.builder()
 *             .policyName(example.policyName())
 *             .policyDocument("""
 * 		{
 * 			"Statement": [{
 * 				"Action": ["oss:*"],
 * 				"Effect": "Allow",
 * 				"Resource": ["acs:oss:*:*:myphotos"]
 * 			}],
 * 			"Version": "1"
 * 		}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:Policy
 *     properties:
 *       policyName: ${name}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:*"]
 *         			}],
 *         			"Version": "1"
 *         		}
 *   examplePolicyVersion:
 *     type: alicloud:resourcemanager:PolicyVersion
 *     name: example
 *     properties:
 *       policyName: ${example.policyName}
 *       policyDocument: |
 *         		{
 *         			"Statement": [{
 *         				"Action": ["oss:*"],
 *         				"Effect": "Allow",
 *         				"Resource": ["acs:oss:*:*:myphotos"]
 *         			}],
 *         			"Version": "1"
 *         		}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Policy Version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/policyVersion:PolicyVersion example tftest:v2
 * ```
 * @property isDefaultVersion Specifies whether to set the policy version as the default version. Default to `false`.
 * @property policyDocument The content of the policy. The content must be 1 to 2,048 characters in length.
 * @property policyName The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
 */
public data class PolicyVersionArgs(
    @Deprecated(
        message = """
  Field 'is_default_version' has been deprecated from provider version 1.90.0
  """,
    )
    public val isDefaultVersion: Output<Boolean>? = null,
    public val policyDocument: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.PolicyVersionArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.PolicyVersionArgs =
        com.pulumi.alicloud.resourcemanager.PolicyVersionArgs.builder()
            .isDefaultVersion(isDefaultVersion?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyVersionArgs].
 */
@PulumiTagMarker
public class PolicyVersionArgsBuilder internal constructor() {
    private var isDefaultVersion: Output<Boolean>? = null

    private var policyDocument: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value Specifies whether to set the policy version as the default version. Default to `false`.
     */
    @Deprecated(
        message = """
  Field 'is_default_version' has been deprecated from provider version 1.90.0
  """,
    )
    @JvmName("wdispouytuvxyhuu")
    public suspend fun isDefaultVersion(`value`: Output<Boolean>) {
        this.isDefaultVersion = value
    }

    /**
     * @param value The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    @JvmName("qatmblmdyapqewrl")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("rjdenowfxnxlvfvm")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Specifies whether to set the policy version as the default version. Default to `false`.
     */
    @Deprecated(
        message = """
  Field 'is_default_version' has been deprecated from provider version 1.90.0
  """,
    )
    @JvmName("okltghfktgsdobwy")
    public suspend fun isDefaultVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefaultVersion = mapped
    }

    /**
     * @param value The content of the policy. The content must be 1 to 2,048 characters in length.
     */
    @JvmName("aurxmhtgbivfohpp")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value The name of the policy. Name must be 1 to 128 characters in length and can contain letters, digits, and hyphens (-).
     */
    @JvmName("uxqmwxukfjnvhafl")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): PolicyVersionArgs = PolicyVersionArgs(
        isDefaultVersion = isDefaultVersion,
        policyDocument = policyDocument,
        policyName = policyName,
    )
}
