@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ResourceDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Resource Directory resource. Resource Directory enables you to establish an organizational structure for the resources used by applications of your enterprise. You can plan, build, and manage the resources in a centralized manner by using only one resource directory.
 * For information about Resource Manager Resource Directory and how to use it, see [What is Resource Manager Resource Directory](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).
 * > **NOTE:** Available since v1.84.0.
 * > **NOTE:** An account can only be used to enable a resource directory after it passes enterprise real-name verification. An account that only passed individual real-name verification cannot be used to enable a resource directory.
 * > **NOTE:** Before you destroy the resource, make sure that the following requirements are met:
 *   - All member accounts must be removed from the resource directory.
 *   - All folders except the root folder must be deleted from the resource directory.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * export = async () => {
 *     const default = await alicloud.resourcemanager.getResourceDirectories({});
 *     const defaultResourceDirectory: alicloud.resourcemanager.ResourceDirectory[] = [];
 *     for (const range = {value: 0}; range.value < (_default.directories.length > 0 ? 0 : 1); range.value++) {
 *         defaultResourceDirectory.push(new alicloud.resourcemanager.ResourceDirectory(`default-${range.value}`, {status: "Enabled"}));
 *     }
 * }
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.resourcemanager.get_resource_directories()
 * default_resource_directory = []
 * for range in [{"value": i} for i in range(0, 0 if len(default&#46;directories) > 0 else 1)]:
 *     default_resource_directory.append(alicloud.resourcemanager.ResourceDirectory(f"default-{range['value']}", status="Enabled"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Threading.Tasks;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(async() =>
 * {
 *     var @default = await AliCloud.ResourceManager.GetResourceDirectories.InvokeAsync();
 *     var defaultResourceDirectory = new List<AliCloud.ResourceManager.ResourceDirectory>();
 *     for (var rangeIndex = 0; rangeIndex < @default.Directories.Length > 0 ? 0 : 1; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultResourceDirectory.Add(new AliCloud.ResourceManager.ResourceDirectory($"default-{range.Value}", new()
 *         {
 *             Status = "Enabled",
 *         }));
 *     }
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := resourcemanager.GetResourceDirectories(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var tmp0 float64
 * 		if pulumi.Float64(len(_default.Directories)) > 0 {
 * 			tmp0 = 0
 * 		} else {
 * 			tmp0 = 1
 * 		}
 * 		var defaultResourceDirectory []*resourcemanager.ResourceDirectory
 * 		for index := 0; index < tmp0; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := resourcemanager.NewResourceDirectory(ctx, fmt.Sprintf("default-%v", key0), &resourcemanager.ResourceDirectoryArgs{
 * 				Status: pulumi.String("Enabled"),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultResourceDirectory = append(defaultResourceDirectory, __res)
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceDirectoriesArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceDirectory;
 * import com.pulumi.alicloud.resourcemanager.ResourceDirectoryArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ResourcemanagerFunctions.getResourceDirectories();
 *         for (var i = 0; i < default_.directories().length() > 0 ? 0 : 1; i++) {
 *             new ResourceDirectory("defaultResourceDirectory-" + i, ResourceDirectoryArgs.builder()
 *                 .status("Enabled")
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultResourceDirectory:
 *     type: alicloud:resourcemanager:ResourceDirectory
 *     name: default
 *     properties:
 *       status: Enabled
 *     options: {}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceDirectories
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Resource Directory can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/resourceDirectory:ResourceDirectory example rd-s3****
 * ```
 * @property memberDeletionStatus Specifies whether to enable the member deletion feature. Valid values:`Enabled` and `Disabled`.
 * @property status The status of control policy. Valid values:`Enabled` and `Disabled`.
 */
public data class ResourceDirectoryArgs(
    public val memberDeletionStatus: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ResourceDirectoryArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ResourceDirectoryArgs =
        com.pulumi.alicloud.resourcemanager.ResourceDirectoryArgs.builder()
            .memberDeletionStatus(memberDeletionStatus?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceDirectoryArgs].
 */
@PulumiTagMarker
public class ResourceDirectoryArgsBuilder internal constructor() {
    private var memberDeletionStatus: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Specifies whether to enable the member deletion feature. Valid values:`Enabled` and `Disabled`.
     */
    @JvmName("gviahonwqlowxnts")
    public suspend fun memberDeletionStatus(`value`: Output<String>) {
        this.memberDeletionStatus = value
    }

    /**
     * @param value The status of control policy. Valid values:`Enabled` and `Disabled`.
     */
    @JvmName("yykiokndhsqjrwqi")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies whether to enable the member deletion feature. Valid values:`Enabled` and `Disabled`.
     */
    @JvmName("xyywhywngrpnleqi")
    public suspend fun memberDeletionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberDeletionStatus = mapped
    }

    /**
     * @param value The status of control policy. Valid values:`Enabled` and `Disabled`.
     */
    @JvmName("rxwmrvtbcifavjbw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ResourceDirectoryArgs = ResourceDirectoryArgs(
        memberDeletionStatus = memberDeletionStatus,
        status = status,
    )
}
