@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.kotlin.outputs.ResourceGroupRegionStatus
import com.pulumi.alicloud.resourcemanager.kotlin.outputs.ResourceGroupRegionStatus.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ResourceGroup].
 */
@PulumiTagMarker
public class ResourceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGroupArgs = ResourceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGroupArgsBuilder.() -> Unit) {
        val builder = ResourceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceGroup {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.ResourceGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceGroup(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Resource Group resource. If you need to group cloud resources according to business departments, projects, and other dimensions, you can create resource groups.
 * For information about Resource Manager Resource Group and how to use it, see [What is Resource Group](https://www.alibabacloud.com/help/en/resource-management/developer-reference/api-createresourcegroup).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.ResourceGroup("example", {
 *     resourceGroupName: name,
 *     displayName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.ResourceGroup("example",
 *     resource_group_name=name,
 *     display_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.ResourceGroup("example", new()
 *     {
 *         ResourceGroupName = name,
 *         DisplayName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceGroup(ctx, "example", &resourcemanager.ResourceGroupArgs{
 * 			ResourceGroupName: pulumi.String(name),
 * 			DisplayName:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new ResourceGroup("example", ResourceGroupArgs.builder()
 *             .resourceGroupName(name)
 *             .displayName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       resourceGroupName: ${name}
 *       displayName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Resource Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/resourceGroup:ResourceGroup example <id>
 * ```
 */
public class ResourceGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.ResourceGroup,
) : KotlinCustomResource(javaResource, ResourceGroupMapper) {
    /**
     * The ID of the Alibaba Cloud account to which the resource group belongs.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The display name of the resource group. The name must be 1 to 50 characters in length.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name` instead.
     */
    @Deprecated(
        message = """
  Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name`
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the resource group in all regions.
     */
    public val regionStatuses: Output<List<ResourceGroupRegionStatus>>
        get() = javaResource.regionStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The unique identifier of the resource group. The identifier must be 3 to 50 characters in length and can contain letters, digits, and hyphens (-). The identifier must start with a letter.
     */
    public val resourceGroupName: Output<String>
        get() = javaResource.resourceGroupName().applyValue({ args0 -> args0 })

    /**
     * The status of the resource group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object ResourceGroupMapper : ResourceMapper<ResourceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.ResourceGroup::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGroup = ResourceGroup(
        javaResource as
            com.pulumi.alicloud.resourcemanager.ResourceGroup,
    )
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGroup].
 */
public suspend fun resourceGroup(
    name: String,
    block: suspend ResourceGroupResourceBuilder.() -> Unit,
): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGroup(name: String): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
