@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Resource Manager Resource Group resource. If you need to group cloud resources according to business departments, projects, and other dimensions, you can create resource groups.
 * For information about Resource Manager Resource Group and how to use it, see [What is Resource Group](https://www.alibabacloud.com/help/en/resource-management/developer-reference/api-createresourcegroup).
 * > **NOTE:** Available since v1.82.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.resourcemanager.ResourceGroup("example", {
 *     resourceGroupName: name,
 *     displayName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.resourcemanager.ResourceGroup("example",
 *     resource_group_name=name,
 *     display_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.ResourceManager.ResourceGroup("example", new()
 *     {
 *         ResourceGroupName = name,
 *         DisplayName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceGroup(ctx, "example", &resourcemanager.ResourceGroupArgs{
 * 			ResourceGroupName: pulumi.String(name),
 * 			DisplayName:       pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new ResourceGroup("example", ResourceGroupArgs.builder()
 *             .resourceGroupName(name)
 *             .displayName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       resourceGroupName: ${name}
 *       displayName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Resource Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/resourceGroup:ResourceGroup example <id>
 * ```
 * @property displayName The display name of the resource group. The name must be 1 to 50 characters in length.
 * @property name Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name` instead.
 * @property resourceGroupName The unique identifier of the resource group. The identifier must be 3 to 50 characters in length and can contain letters, digits, and hyphens (-). The identifier must start with a letter.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class ResourceGroupArgs(
    public val displayName: Output<String>? = null,
    @Deprecated(
        message = """
  Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name`
      instead.
  """,
    )
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.resourcemanager.ResourceGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.resourcemanager.ResourceGroupArgs =
        com.pulumi.alicloud.resourcemanager.ResourceGroupArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGroupArgs].
 */
@PulumiTagMarker
public class ResourceGroupArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The display name of the resource group. The name must be 1 to 50 characters in length.
     */
    @JvmName("cocreskbjxhhqlro")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name` instead.
     */
    @Deprecated(
        message = """
  Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name`
      instead.
  """,
    )
    @JvmName("usfbmtcyvoedxdif")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The unique identifier of the resource group. The identifier must be 3 to 50 characters in length and can contain letters, digits, and hyphens (-). The identifier must start with a letter.
     */
    @JvmName("fsqpoixocoqolorq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("oevafyqylmimqtfe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The display name of the resource group. The name must be 1 to 50 characters in length.
     */
    @JvmName("mbprtnfphdknqhhy")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name` instead.
     */
    @Deprecated(
        message = """
  Field `name` has been deprecated from provider version 1.114.0. New field `resource_group_name`
      instead.
  """,
    )
    @JvmName("sqcbhvljjmywfoos")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The unique identifier of the resource group. The identifier must be 3 to 50 characters in length and can contain letters, digits, and hyphens (-). The identifier must start with a letter.
     */
    @JvmName("fvvbhimixavwmqej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("qgjcsoasucpxlrgt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("tcladnfuconbyqml")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGroupArgs = ResourceGroupArgs(
        displayName = displayName,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
