@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.resourcemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourceShare].
 */
@PulumiTagMarker
public class ResourceShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceShareArgs = ResourceShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceShareArgsBuilder.() -> Unit) {
        val builder = ResourceShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceShare {
        val builtJavaResource =
            com.pulumi.alicloud.resourcemanager.ResourceShare(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceShare(builtJavaResource)
    }
}

/**
 * Provides a Resource Manager Resource Share resource.
 * For information about Resource Manager Resource Share and how to use it, see [What is Resource Share](https://www.alibabacloud.com/help/en/doc-detail/94475.htm).
 * > **NOTE:** Available since v1.111.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = new alicloud.resourcemanager.ResourceShare("example", {resourceShareName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.resourcemanager.ResourceShare("example", resource_share_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = new AliCloud.ResourceManager.ResourceShare("example", new()
 *     {
 *         ResourceShareName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceShare(ctx, "example", &resourcemanager.ResourceShareArgs{
 * 			ResourceShareName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceShare;
 * import com.pulumi.alicloud.resourcemanager.ResourceShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         var example = new ResourceShare("example", ResourceShareArgs.builder()
 *             .resourceShareName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:resourcemanager:ResourceShare
 *     properties:
 *       resourceShareName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Resource Manager Resource Share can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:resourcemanager/resourceShare:ResourceShare example <id>
 * ```
 */
public class ResourceShare internal constructor(
    override val javaResource: com.pulumi.alicloud.resourcemanager.ResourceShare,
) : KotlinCustomResource(javaResource, ResourceShareMapper) {
    /**
     * The name of resource share.
     */
    public val resourceShareName: Output<String>
        get() = javaResource.resourceShareName().applyValue({ args0 -> args0 })

    /**
     * The owner of the Resource Share.
     */
    public val resourceShareOwner: Output<String>
        get() = javaResource.resourceShareOwner().applyValue({ args0 -> args0 })

    /**
     * The status of the Resource Share.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ResourceShareMapper : ResourceMapper<ResourceShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.resourcemanager.ResourceShare::class == javaResource::class

    override fun map(javaResource: Resource): ResourceShare = ResourceShare(
        javaResource as
            com.pulumi.alicloud.resourcemanager.ResourceShare,
    )
}

/**
 * @see [ResourceShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceShare].
 */
public suspend fun resourceShare(
    name: String,
    block: suspend ResourceShareResourceBuilder.() -> Unit,
): ResourceShare {
    val builder = ResourceShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceShare(name: String): ResourceShare {
    val builder = ResourceShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
